<?php
use App\Models\DB;

$pdo = DB::pdo();

/* -------- Town Info -------- */
$town = $pdo->query("
    SELECT Name, Address1, Address2, Town, State, Zip,
           Phone1, Phone2, Email
    FROM town
    LIMIT 1
")->fetch(PDO::FETCH_ASSOC);

/* -------- Office Hours -------- */
$hours = $pdo->query("
    SELECT DayOfWeek, OpenTime, CloseTime
    FROM hours
    ORDER BY FIELD(DayOfWeek,
      'Monday','Tuesday','Wednesday','Thursday',
      'Friday','Saturday','Sunday')
")->fetchAll(PDO::FETCH_ASSOC);

$dayMap = [
    1 => 'Monday',
    2 => 'Tuesday',
    3 => 'Wednesday',
    4 => 'Thursday',
    5 => 'Friday',
    6 => 'Saturday',
    7 => 'Sunday',
];
?>

<div class="card shadow-sm mb-4">
  <div class="card-body text-center">

    <img src="https://www.cushing.maine.gov/wp-content/uploads/2014/05/cushing-town-offices1.jpg"
         class="img-fluid rounded mb-3"
         alt="Town Office">

    <h5 class="fw-bold mb-2"><?= htmlspecialchars($town['Name']) ?></h5>

    <div class="mb-2">
      <?= htmlspecialchars($town['Address1']) ?><br>
      <?php if ($town['Address2']): ?>
        <?= htmlspecialchars($town['Address2']) ?><br>
      <?php endif; ?>
      <?= htmlspecialchars($town['Town']) ?>,
      <?= htmlspecialchars($town['State']) ?>
      <?= htmlspecialchars($town['Zip']) ?>
    </div>

    <?php if ($town['Phone1']): ?>
      <div class="mb-1">
        <strong>Phone:</strong> <?= htmlspecialchars($town['Phone1']) ?>
      </div>
    <?php endif; ?>

    <?php if ($town['Email']): ?>
      <div class="mb-2">
        <a href="mailto:<?= htmlspecialchars($town['Email']) ?>">
          <?= htmlspecialchars($town['Email']) ?>
        </a>
      </div>
    <?php endif; ?>

    <hr>

    <?php if (!empty($hours)): ?>
      <section class="mb-4">
        <h5 class="mb-3">Town Office Hours</h5>

        <?php foreach ($hours as $h): ?>
          <?php
            $dayNum = (int)$h['DayOfWeek'];
            $dayLabel = $dayMap[$dayNum] ?? 'Unknown';

            $open  = $h['OpenTime'];
            $close = $h['CloseTime'];
          ?>

          <div class="d-flex justify-content-between">
            <span><?= htmlspecialchars($dayLabel) ?></span>
            <span>
              <?= htmlspecialchars($open) ?>
              –
              <?= htmlspecialchars($close) ?>
            </span>
          </div>

        <?php endforeach; ?>
      </section>
    <?php endif; ?>

  </div>
</div>
