<h2 class="h5">Resources</h2>
<?php if (empty($resources)): ?>
  <p class="text-muted mb-0">No resources available yet.</p>
<?php else: ?>
  <div class="row g-3">
    <?php foreach ($resources as $r): $id = (int)$r['Id']; ?>
      <?php
        $label = trim(($r['Title'] ? ($r['Title'].'  ') : '').trim(($r['Description'] ? ' - '.($r['Description'].'  ') : '')));
        $primaryHref = null;
        if (!empty($r['Url'])) {
          $primaryHref = $r['Url'];
        } elseif (!empty($resAtt[$id])) {
          $a0 = $resAtt[$id][0];
          $primaryHref = !empty($a0['Url'])
            ? $a0['Url']
            : build_file_href($a0['FilePath'] ?? null, $a0['FileName'] ?? null);
        }
      ?>
      <div class="col-12 col-md-6 col-lg-4">
        <article class="card h-100">
          <div class="card-body text-center">
            <!--h3 class="h6 mb-2"><?= hbold($r['Title']) ?></h3-->
            <?php if ($primaryHref): ?>
              <p class="mb-2">
                <a href="<?= esc($primaryHref) ?>" target="_blank" class="link-success text-decoration-none">
                  <?= esc($label) ?>
                </a>
                <!--a class="btn btn-success btn-sm" href="<?= esc($primaryHref) ?>" target="_blank" rel="noopener"><?= esc($label) ?></a-->
              </p>
            <?php else: ?>
              <p class="text-muted mb-2">No primary link</p>
            <?php endif; ?>
            <?= render_attachments($resAtt[$id] ?? []) ?>
          </div>
        </article>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
