    <section id="boards" class="mb-4">
      <h2 class="h5">Boards & Committees</h2>
    
      <?php if (!$boards): ?>
        <p class="text-muted">No boards listed.</p>
    
      <?php else: ?>
        <div class="row g-3">
          <?php foreach ($boards as $b): ?>
    
            <?php
              // resolve logo path (you already know how to map)
              $slug = strtolower(str_replace(' ', '_', $b['Name']));
              //$logoPath = "/images/board_logos/{$slug}.svg"; 
              $logoPath = "./images/board_logos/Animal.gif"; 
            ?>
    
            <div class="col-12 col-md-4">
              <article class="card h-100">
    
                <!-- FLEX WRAPPER ADDED HERE -->
                <div class="card-body d-flex justify-content-between align-items-center">
    
                  <!-- LEFT SIDE: Title + Button -->
                  <div class="text-center flex-grow-1">
                    <h3 class="h6 mb-2"><?= hbold($b['Name']) ?></h3>

                    <a class="btn btn-outline-success btn-sm"
                       href="index.php?boardid=<?= (int)$b['Id'] ?>">
                       View board
                    </a>

                  </div>
    
                  <!-- RIGHT SIDE: LOGO -->
                  <img src="<?= $logoPath ?>"
                       alt="<?= htmlspecialchars($b['Name']) ?> logo"
                       style="width:48px;height:auto;"
                       class="ms-3">
    
                </div><!-- /card-body -->
    
              </article>
            </div>
    
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </section>
    