<?php
// /WebSite/information/show.php
require_once __DIR__ . '/../../config/config.php';  // adjust if needed
require_once __DIR__ . '/../app/Models/DB.php';
require_once __DIR__ . '/../app/Helpers/Helpers.php';

use App\Models\DB;
use App\Helpers\HELP;

// Get id
$id = isset($_GET['informationid']) ? (int)$_GET['informationid'] : 0;

$pdo=DB::pdo();

// Fetch record
$stmt = $pdo->prepare("
    SELECT * from information
    WHERE Id = ?
");
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    http_response_code(404);
    echo "<div class='container py-5'><p class='text-danger'>Information not found.</p></div>";
    exit;
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= HELP::esc($row['Role']) ?> – Town of Cushing</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/WebSite/style.css">
</head>
<body class="bg-light">

<div class="container" style="margin-top: 2rem;">
  <div class="row justify-content-center">
    <div class="col-12 col-lg-8">
      <article class="card shadow-sm">
        <div class="card-body">

          <!--a href="<?= HELP::url('/WebSite') ?>"
             class="btn btn-outline-secondary btn-sm">
             ← Back
          </a-->

          <button type="button"
                  class="btn btn-outline-secondary btn-sm mb-2"
                  onclick="window.history.length > 1 ? history.back() : window.location='/'">
              &larr; Back
          </button>

          <!--div class="text-center mt-4">
            <a href="/WebSite/index.php" class="btn btn-outline-secondary btn-sm back-to-home">← Back to Home</a>
          </div-->

          <h1 class="h4 text-center mb-4">Information - <?= HELP::esc($row['Role']) ?></h1>

          <?php if (!empty($row['Category'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Category: 
              <?= nl2br(HELP::esc($row['Category'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['ContactName'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Contact: 
              <?= nl2br(HELP::esc($row['ContactName'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['Location'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Location: 
              <?= nl2br(HELP::esc($row['Location'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['MailAddress'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">MailAddress: 
              <?= nl2br(HELP::esc($row['MailAddress'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['PhonePrimary'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Phone: 
              <?= nl2br(HELP::esc($row['PhonePrimary'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['Email'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">
                Email:
                <a href="mailto:<?= HELP::esc($row['Email']) ?>">
                  <?= nl2br(HELP::esc($row['Email'])) ?>
                </a>
              </h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['Hours'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Hours: 
              <?= nl2br(HELP::esc($row['Hours'])) ?></h2>
            </section>
          <?php endif; ?>

          <?php if (!empty($row['Notes'])): ?>
            <section class="mb-3">
              <h2 class="h6 text-muted">Notes: 
              <?= nl2br(HELP::esc($row['Notes'])) ?></h2>
            </section>
          <?php endif; ?>
      </article>
    </div>
  </div>
</div>

</body>
</html>
  