<?php

use App\Controllers\HomeController;
use App\Controllers\AuthController;
use App\Controllers\AnnouncementsController;
use App\Controllers\BoardLinksController;
use App\Controllers\BoardMeetingsController;
use App\Controllers\BoardsAndCommitteeMembersController;
use App\Controllers\BoardsAndCommitteesController;
use App\Controllers\BoardScheduleRulesController;
use App\Controllers\EventsController;
use App\Controllers\OfficerPositionsController;
use App\Controllers\ResourcesController;
use App\Controllers\AttachmentsController;
use App\Controllers\TownStaffPositionsController;

#new 10/6/25
use App\Controllers\CommunityController;
use App\Controllers\InformationController;
use App\Controllers\OrdinancesRegulationsFormsController;

#new 10/14/25
//use App\Controllers\BoardMeetingMinutesController;
use App\Controllers\TaxMapsController;

#new 12/4/25
use App\Controllers\FireAndSafetyController;
use App\Controllers\TownMeetingsAndReportsController;

#new 11/7/25
use App\Controllers\TownController;

$router->get('/', [HomeController::class, 'index']);

$router->get('/login', [AuthController::class, 'loginForm']);
$router->post('/login', [AuthController::class, 'login']);
$router->post('/logout', [AuthController::class, 'logout']);

$router->get('/announcements', [AnnouncementsController::class, 'index']);
$router->get('/announcements/create', [AnnouncementsController::class, 'create']);
$router->post('/announcements/store', [AnnouncementsController::class, 'store']);
$router->get('/announcements/edit', [AnnouncementsController::class, 'edit']);
$router->post('/announcements/update', [AnnouncementsController::class, 'update']);
$router->post('/announcements/delete', [AnnouncementsController::class, 'delete']);

$router->get('/boardlinks', [BoardLinksController::class, 'index']);
$router->get('/boardlinks/create', [BoardLinksController::class, 'create']);
$router->post('/boardlinks/store', [BoardLinksController::class, 'store']);
$router->get('/boardlinks/edit', [BoardLinksController::class, 'edit']);
$router->post('/boardlinks/update', [BoardLinksController::class, 'update']);
$router->post('/boardlinks/delete', [BoardLinksController::class, 'delete']);

$router->get('/boardmeetings', [BoardMeetingsController::class, 'index']);
$router->get('/boardmeetings/create', [BoardMeetingsController::class, 'create']);
$router->post('/boardmeetings/store', [BoardMeetingsController::class, 'store']);
$router->get('/boardmeetings/edit', [BoardMeetingsController::class, 'edit']);
$router->post('/boardmeetings/update', [BoardMeetingsController::class, 'update']);
$router->post('/boardmeetings/delete', [BoardMeetingsController::class, 'delete']);

//$router->get('/boardmeetingminutes', [BoardMeetingMinutesController::class, 'index']);
//$router->get('/boardmeetingminutes/create', [BoardMeetingMinutesController::class, 'create']);
//$router->post('/boardmeetingminutes/store', [BoardMeetingMinutesController::class, 'store']);
//$router->get('/boardmeetingminutes/edit', [BoardMeetingMinutesController::class, 'edit']);
//$router->post('/boardmeetingminutes/update', [BoardMeetingMinutesController::class, 'update']);
//$router->post('/boardmeetingminutes/delete', [BoardMeetingMinutesController::class, 'delete']);

#new 10/14/25
//testing new type of controller
//$bm = new BoardMeetingMinutesController();
//$router->get('/boardmeetingminutes',            [$bm, 'index']);
//$router->get('/boardmeetingminutes/create',     [$bm, 'create']);
//$router->post('/boardmeetingminutes/store',     [$bm, 'store']);
//$router->get('/boardmeetingminutes/edit',       [$bm, 'edit']);
//$router->post('/boardmeetingminutes/update',    [$bm, 'update']);
//$router->post('/boardmeetingminutes/delete',    [$bm, 'delete']);
//

$router->get('/boardsandcommitteemembers', [BoardsAndCommitteeMembersController::class, 'index']);
$router->get('/boardsandcommitteemembers/create', [BoardsAndCommitteeMembersController::class, 'create']);
$router->post('/boardsandcommitteemembers/store', [BoardsAndCommitteeMembersController::class, 'store']);
$router->get('/boardsandcommitteemembers/edit', [BoardsAndCommitteeMembersController::class, 'edit']);
$router->post('/boardsandcommitteemembers/update', [BoardsAndCommitteeMembersController::class, 'update']);
$router->post('/boardsandcommitteemembers/delete', [BoardsAndCommitteeMembersController::class, 'delete']);

$router->get('/boardsandcommittees', [BoardsAndCommitteesController::class, 'index']);
$router->get('/boardsandcommittees/create', [BoardsAndCommitteesController::class, 'create']);
$router->post('/boardsandcommittees/store', [BoardsAndCommitteesController::class, 'store']);
$router->get('/boardsandcommittees/edit', [BoardsAndCommitteesController::class, 'edit']);
$router->post('/boardsandcommittees/update', [BoardsAndCommitteesController::class, 'update']);
$router->post('/boardsandcommittees/delete', [BoardsAndCommitteesController::class, 'delete']);

$router->get('/boardschedulerules', [BoardScheduleRulesController::class, 'index']);
$router->get('/boardschedulerules/create', [BoardScheduleRulesController::class, 'create']);
$router->post('/boardschedulerules/store', [BoardScheduleRulesController::class, 'store']);
$router->get('/boardschedulerules/edit', [BoardScheduleRulesController::class, 'edit']);
$router->post('/boardschedulerules/update', [BoardScheduleRulesController::class, 'update']);
$router->post('/boardschedulerules/delete', [BoardScheduleRulesController::class, 'delete']);

$router->get('/events', [EventsController::class, 'index']);
$router->get('/events/create', [EventsController::class, 'create']);
$router->post('/events/store', [EventsController::class, 'store']);
$router->get('/events/edit', [EventsController::class, 'edit']);
$router->post('/events/update', [EventsController::class, 'update']);
$router->post('/events/delete', [EventsController::class, 'delete']);

$router->get('/officerpositions', [OfficerPositionsController::class, 'index']);
$router->get('/officerpositions/create', [OfficerPositionsController::class, 'create']);
$router->post('/officerpositions/store', [OfficerPositionsController::class, 'store']);
$router->get('/officerpositions/edit', [OfficerPositionsController::class, 'edit']);
$router->post('/officerpositions/update', [OfficerPositionsController::class, 'update']);
$router->post('/officerpositions/delete', [OfficerPositionsController::class, 'delete']);

$router->get('/resources', [ResourcesController::class, 'index']);
$router->get('/resources/create', [ResourcesController::class, 'create']);
$router->post('/resources/store', [ResourcesController::class, 'store']);
$router->get('/resources/edit', [ResourcesController::class, 'edit']);
$router->post('/resources/update', [ResourcesController::class, 'update']);
$router->post('/resources/delete', [ResourcesController::class, 'delete']);

$router->get('/townstaffpositions', [TownStaffPositionsController::class, 'index']);
$router->get('/townstaffpositions/create', [TownStaffPositionsController::class, 'create']);
$router->post('/townstaffpositions/store', [TownStaffPositionsController::class, 'store']);
$router->get('/townstaffpositions/edit', [TownStaffPositionsController::class, 'edit']);
$router->post('/townstaffpositions/update', [TownStaffPositionsController::class, 'update']);
$router->post('/townstaffpositions/delete', [TownStaffPositionsController::class, 'delete']);

$router->get('/attachments', [AttachmentsController::class, 'index']);
$router->get('/attachments/create', [AttachmentsController::class, 'create']);
$router->post('/attachments/store', [AttachmentsController::class, 'store']);
$router->post('/attachments/delete', [AttachmentsController::class, 'delete']);

#new 10/6/25
$router->get('/community', [CommunityController::class, 'index']);
$router->get('/community/create', [CommunityController::class, 'create']);
$router->post('/community/store', [CommunityController::class, 'store']);
$router->get('/community/edit', [CommunityController::class, 'edit']);
$router->post('/community/update', [CommunityController::class, 'update']);
$router->post('/community/delete', [CommunityController::class, 'delete']);

$router->get('/information', [InformationController::class, 'index']);
$router->get('/information/create', [InformationController::class, 'create']);
$router->post('/information/store', [InformationController::class, 'store']);
$router->get('/information/edit', [InformationController::class, 'edit']);
$router->post('/information/update', [InformationController::class, 'update']);
$router->post('/information/delete', [InformationController::class, 'delete']);

$router->get('/ordinancesregulationsforms', [OrdinancesRegulationsFormsController::class, 'index']);
$router->get('/ordinancesregulationsforms/create', [OrdinancesRegulationsFormsController::class, 'create']);
$router->post('/ordinancesregulationsforms/store', [OrdinancesRegulationsFormsController::class, 'store']);
$router->get('/ordinancesregulationsforms/edit', [OrdinancesRegulationsFormsController::class, 'edit']);
$router->post('/ordinancesregulationsforms/update', [OrdinancesRegulationsFormsController::class, 'update']);
$router->post('/ordinancesregulationsforms/delete', [OrdinancesRegulationsFormsController::class, 'delete']);

#new 10/14/25
//testing new type of controller
//$tm = new TaxMapsController();
//$router->get('/taxmaps',            [$tm, 'index']);
//$router->get('/taxmaps/create',     [$tm, 'create']);
//$router->post('/taxmaps/store',     [$tm, 'store']);
//$router->get('/taxmaps/edit',       [$tm, 'edit']);
//$router->post('/taxmaps/update',    [$tm, 'update']);
//$router->post('/taxmaps/delete',    [$tm, 'delete']);
//

$router->get('/taxmaps', [TaxMapsController::class, 'index']);
$router->get('/taxmaps/create', [TaxMapsController::class, 'create']);
$router->post('/taxmaps/store', [TaxMapsController::class, 'store']);
$router->get('/taxmaps/edit', [TaxMapsController::class, 'edit']);
$router->post('/taxmaps/update', [TaxMapsController::class, 'update']);
$router->post('/taxmaps/delete', [TaxMapsController::class, 'delete']);

//testing new type of controller
$tn = new TownController();
$router->get('/town',            [$tn, 'index']);
$router->get('/town/create',     [$tn, 'create']);
$router->post('/town/store',     [$tn, 'store']);
$router->get('/town/edit',       [$tn, 'edit']);
$router->post('/town/update',    [$tn, 'update']);

$router->get('/fireandsafety', [FireAndSafetyController::class, 'index']);
$router->get('/fireandsafety/create', [FireAndSafetyController::class, 'create']);
$router->post('/fireandsafety/store', [FireAndSafetyController::class, 'store']);
$router->get('/fireandsafety/edit', [FireAndSafetyController::class, 'edit']);
$router->post('/fireandsafety/update', [FireAndSafetyController::class, 'update']);
$router->post('/fireandsafety/delete', [FireAndSafetyController::class, 'delete']);

$router->get('/townmeetingsandreports', [TownMeetingsAndReportsController::class, 'index']);
$router->get('/townmeetingsandreports/create', [TownMeetingsAndReportsController::class, 'create']);
$router->post('/townmeetingsandreports/store', [TownMeetingsAndReportsController::class, 'store']);
$router->get('/townmeetingsandreports/edit', [TownMeetingsAndReportsController::class, 'edit']);
$router->post('/townmeetingsandreports/update', [TownMeetingsAndReportsController::class, 'update']);
$router->post('/townmeetingsandreports/delete', [TownMeetingsAndReportsController::class, 'delete']);
