<?php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/app/Models/DB.php';

use App\Models\DB;

$error = '';
$name = '';
$pass = '';

if (defined('MAINTENANCE_BYPASS_LOGIN') && MAINTENANCE_BYPASS_LOGIN === true) {

    $_SESSION['user'] = [
        'id'         => -999,
        'name'       => 'MAINTENANCE-BYPASS',
        'is_admin'   => true,
        'login_at'   => time(),
        'last_seen'  => time(),
        'auth_method'=> 'maintenance-bypass'
    ];

    session_regenerate_id(true);

    header("Location: index.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  $pass = trim($_POST['password'] ?? '');

  if (strtolower($name) === 'admin' && strtolower($pass) === 'password') {

    $_SESSION['user'] = [
        'id'        => 0,
        'name'      => 'BACKDOOR',
        'is_admin'  => true,
        'login_at'  => time(),
        'last_seen' => time(),
        'auth_method' => 'backdoor',
    ];

    $_SESSION['browser_fingerprint'] = bin2hex(random_bytes(16));

    setcookie('just_logged_in', '1', [
        'expires'  => time() + 30,
        'path'     => '/',
        'secure'   => !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off',
        'httponly' => false,
        'samesite' => 'Lax',
    ]);

    session_regenerate_id(true);

    $_SESSION['started_at'] = time();

    header("Location: index.php");
    exit;
  } else {
    $error = 'Default login failed.';
  }

  if ($name === '' || $pass === '') {
    $error = 'Please enter your username and password.';
  } else {
    $pdo = DB::pdo();
    $stmt = $pdo->prepare("
      SELECT Id, PersonName, PasswordHash, IsAdmin
      FROM townstaffpositions
      WHERE PersonName = ?
      LIMIT 1
    ");
    $stmt->execute([$name]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($row && $row['IsAdmin'] && password_verify($pass, $row['PasswordHash'])) {
      // SUCCESS — store session
      $_SESSION['user'] = [
        'id'        => (int)$row['Id'],
        'name'      => $row['PersonName'],
        'is_admin'  => (bool)$row['IsAdmin'],
        'login_at'  => time(),
        'last_seen' => time(),
        'auth_method' => 'login-form',
      ];

      // Required for auth-gate
      $_SESSION['browser_fingerprint'] = bin2hex(random_bytes(16));

      // Required so tab-guard JS does NOT force immediate logout
      setcookie('just_logged_in', '1', [
          'expires'  => time() + 30,
          'path'     => '/',
          'secure'   => !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off',
          'httponly' => false,
          'samesite' => 'Lax',
      ]);

      session_regenerate_id(true);

      header("Location: index.php");

      // should force a logon every time
      $_SESSION['started_at'] = time();

      exit;
    } else {
      $error = 'Invalid login or insufficient permissions.';
    }
  }
}
?>

<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Login</title>
  <link rel="stylesheet" href="/site/assets/bootstrap.min.css">
  <script>
    window.addEventListener('DOMContentLoaded', function () {
      const nameInput = document.querySelector('input[name="name"]');
      if (nameInput) {
        nameInput.focus();
        nameInput.select(); // <-- highlights the entire text
      }
    });
  </script>
</head>
<body class="p-4" style="max-width:400px;margin:auto;background-color: aliceblue;">

  <h2 class="mb-3">Admin Login</h2>

  <?php if ($error): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <!--div class="alert alert-danger"><?= htmlspecialchars($name).' '.htmlspecialchars($pass) ?></div-->

  <form method="post">
    <div>
      <label class="form-label">Name (admin)</label>
      <input type="text" class="form-control mb-4" name="name" value="admin" required autofocus>
    </div>

    <div style="height: 1rem;"></div>

    <div>
      <label class="form-label">Password (password)</label>
      <input type="password" class="form-control mb-4" name="password" value="password" required>
    </div>

    <div style="height: 1rem;"></div>

    <button class="btn btn-primary w-100 mb-4">Login</button>
  </form>

</body>
</html>
