<?php
declare(strict_types=1);

// ---------- Auth gate (session-based, single front controller) ----------
// Must be BEFORE session_start()
$secure   = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off';
session_set_cookie_params([
  'lifetime' => 0,            // session cookie; should die when browser fully exits
  'path'     => '/',          // adjust if you need a subpath
  'domain'   => '',           // default
  'secure'   => $secure,      // only over HTTPS in prod
  'httponly' => true,         // not readable by JS
  'samesite' => 'Lax',
]);

session_start();

// =============================
// MAINTENANCE AUTH BYPASS
// =============================
// !!! REMOVE OR SET TO FALSE AFTER REGRESSION TESTING !!!
define('MAINTENANCE_BYPASS_LOGIN', false);

// force a logon
if (!isset($_SESSION['browser_fingerprint'])) {
    // New session, even if browser restored cookie
    $_SESSION = [];
    session_destroy();
    header("Location: /Maintenance/login.php");
    //header("Location: login.php");
    exit;
}

// Optional inactivity timeout (minutes)
const IDLE_MINUTES = 60;
const ABSOLUTE_MAX_MIN   = 120; // force re-auth after 2 hours from login

function current_user(): ?array {
    return $_SESSION['user'] ?? null;
}
function redirect_strip_query(): void {
    $uri = strtok($_SERVER['REQUEST_URI'] ?? '/', '?'); // path only, no query
    header('Location: ' . $uri, true, 302);
    exit;
}
function forbid_and_exit(): void {
    http_response_code(403);
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    ?>
    <!doctype html><html><head><meta charset="utf-8"><title>Access denied</title></head>
    <body style="font-family:system-ui,Segoe UI,Roboto,Arial;margin:2rem">
      <h2 style="color:#b00020">Access denied</h2>
      <p>A valid authorization is required.</p>
    </body></html>
    <?php
    exit;
}

function is_logged_in(): bool {
  return !empty($_SESSION['user']) && !empty($_SESSION['user']['is_admin']);
}

if (!is_logged_in()) {
  header("Location: /Maintenance/login.php");
  //header("Location: login.php");
  exit;
}

// Idle timeout (optional)
$now = time();
$last = $_SESSION['user']['last_seen'] ?? $now;
$born = $_SESSION['user']['login_at']  ?? $now;

if ($now - $last > 60*60 || $now - $born > 2*60*60) {
  $_SESSION = [];
  session_destroy();

  header("Location: /Maintenance/login.php");
  //header("Location: login.php");
  exit;
}

$_SESSION['user']['last_seen'] = $now;

// ---------- End auth gate ----------

// ---------- Inject per-tab guard script into all HTML responses ----------
function _inject_tab_guard_html(string $html): string {
    $snippet = <<<HTML
<script>
(function(){
  var KEY = 'auth_tab_token';

  // helper: check and clear just_logged_in cookie
  function wasJustLoggedIn(){
    var m = document.cookie.match(/(?:^|;\\s*)just_logged_in=1(?:;|$)/);
    if (m) {
      // clear it immediately
      document.cookie = 'just_logged_in=; Max-Age=0; path=/';
      return true;
    }
    return false;
  }

  var firstInThisTab = !sessionStorage.getItem(KEY);
  if (firstInThisTab) {
    sessionStorage.setItem(KEY, Math.random().toString(36).slice(2));
    // If we *just* completed the ?auth= flow, do NOT log out—this is the post-login page.
    if (wasJustLoggedIn()) return;
    // Otherwise, this is a fresh tab (e.g., browser restored) → force server logout, then reload.
    fetch('?logout=1', {credentials:'same-origin'}).finally(function(){ location.reload(); });
  }
})();
</script>
HTML;

    if (stripos($html, '</head>') !== false) {
        return preg_replace('/<\/head>/i', $snippet . '</head>', $html, 1);
    }
    if (stripos($html, '<html') === false && stripos($html, '<head') === false) {
        return $html;
    }
    return $snippet . $html;
}
ob_start('_inject_tab_guard_html');

// If we arrive here, auth is accepted and the rest of index.php proceeds...

// Set cookie params BEFORE starting the session.
// If a session is already active (e.g., session.auto_start=1), just reissue the cookie.
//$https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');

//if (session_status() === PHP_SESSION_NONE) {
//    session_set_cookie_params([
//        'lifetime' => 0,
//        'path'     => '/',
//        'secure'   => $https,
//        'httponly' => true,
//        'samesite' => 'Lax',
//    ]);
//    session_start();
//} else {
//    // Session already active; update cookie flags.
//    setcookie(session_name(), session_id(), [
//        'expires'  => 0,
//        'path'     => '/',
//        'secure'   => $https,
//        'httponly' => true,
//        'samesite' => 'Lax',
//    ]);
//}

//session_start();

// Tighten session cookie
//session_set_cookie_params([
//  'lifetime' => 0, 'path' => '/', 'secure' => isset($_SERVER['HTTPS']),
//  'httponly' => true, 'samesite' => 'Lax'
//]);

require __DIR__ . '/../config/config.php';
require __DIR__ . '/app/Router.php';
require __DIR__ . '/app/Helpers/response.php';
require __DIR__ . '/app/Helpers/csrf.php';
require __DIR__ . '/app/Helpers/logger.php';
require __DIR__ . '/app/Helpers/audit.php';
require __DIR__ . '/app/Helpers/filehelper.php';
require __DIR__ . '/app/Models/DB.php';
require __DIR__ . '/app/Controllers/HomeController.php';
require __DIR__ . '/app/Controllers/AuthController.php';
require __DIR__ . '/app/Controllers/AnnouncementsController.php';
require __DIR__ . '/app/Controllers/AttachmentsController.php';
require __DIR__ . '/app/Controllers/BoardLinksController.php';
require __DIR__ . '/app/Controllers/BoardMeetingsController.php';
require __DIR__ . '/app/Controllers/BoardsAndCommitteeMembersController.php';
require __DIR__ . '/app/Controllers/BoardsAndCommitteesController.php';
require __DIR__ . '/app/Controllers/BoardScheduleRulesController.php';
require __DIR__ . '/app/Controllers/EventsController.php';
require __DIR__ . '/app/Controllers/OfficerPositionsController.php';
require __DIR__ . '/app/Controllers/ResourcesController.php';
require __DIR__ . '/app/Controllers/TownStaffPositionsController.php';

#new 10/6/25
require __DIR__ . '/app/Controllers/CommunityController.php';
require __DIR__ . '/app/Controllers/InformationController.php';
require __DIR__ . '/app/Controllers/OrdinancesRegulationsFormsController.php';

#new 10/14/25
//require __DIR__ . '/app/Controllers/BoardMeetingMinutesController.php';
require __DIR__ . '/app/Controllers/TaxMapsController.php';

#new 11/7/25
require __DIR__ . '/app/Controllers/TownController.php';

#new 12/4/25
require __DIR__ . '/app/Controllers/FireAndSafetyController.php';
require __DIR__ . '/app/Controllers/TownMeetingsAndReportsController.php';

// Global error & exception handling
set_exception_handler(function($e){
    \App\Helpers\log_error($e);
    http_response_code(500);
    // Simple friendly error page
    echo "<h1>Something went wrong</h1><p>Please try again later.</p>";
    if (!empty($_ENV['APP_DEBUG'])) {
        echo "<pre>" . htmlspecialchars((string)$e, ENT_QUOTES, 'UTF-8') . "</pre>";
    }
});
register_shutdown_function(function(){
    $err = error_get_last();
    if ($err && in_array($err['type'], [E_ERROR,E_PARSE,E_CORE_ERROR,E_COMPILE_ERROR])) {
        \App\Helpers\log_error($err['message'] . " in {$err['file']}:{$err['line']}");
        http_response_code(500);
        echo "<h1>Server error</h1>";
    }
});

// Verify CSRF on all POSTs
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST') {
    \App\Helpers\csrf_verify();
}
use App\Router;

$router = new Router();

require __DIR__ . '/routes.php';

$router->dispatch($_SERVER['REQUEST_URI'], $_SERVER['REQUEST_METHOD']);
