<?php
/** @var array $model */
/** @var array $errors */

/* Guards */
if (!isset($model) || !is_array($model)) { $model = []; }
if (!isset($errors) || !is_array($errors)) { $errors = []; }

/* Normalize Active -> IsActive for shared form checkbox */
if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
  $model['IsActive'] = (int)$model['Active'];
}

/* Defaults for new record */
$defaults = [
  'Id' => 0,
  'JobTitle'   => '',
  'PersonName' => '',
  'Address1'   => '',
  'Address2'   => '',
  'Town'       => '',
  'State'      => '',
  'Zip'        => '',
  'Phone1'     => '',
  'Phone2'     => '',
  'Email'      => '',
  'Remarks'    => '',
  'IsActive'   => 1,
];
$model = $model + $defaults;

$isEdit     = ((int)$model['Id'] > 0);
$pageTitle  = $pageTitle  ?? ($isEdit ? 'Edit Town Staff Position' : 'New Town Staff Position');
$baseUrl    = $baseUrl    ?? App\Helpers\url('/townstaffpositions');
$formAction = $formAction ?? App\Helpers\url($isEdit ? '/townstaffpositions/update' : '/townstaffpositions/store');

/** Fields for shared/form_base.php */
$fields = [
  ['label'=>'Job Title',   'name'=>'JobTitle',   'type'=>'text',     'required'=>true],
  ['label'=>'Name',        'name'=>'PersonName', 'type'=>'text'],
  ['label'=>'Address 1',   'name'=>'Address1',   'type'=>'text'],
  ['label'=>'Address 2',   'name'=>'Address2',   'type'=>'text'],
  ['label'=>'Town',        'name'=>'Town',       'type'=>'text'],
  ['label'=>'State',       'name'=>'State',      'type'=>'text'],
  ['label'=>'Zip',         'name'=>'Zip',        'type'=>'text'],
  ['label'=>'Phone 1',     'name'=>'Phone1',     'type'=>'text', 'phone'=>true],
  ['label'=>'Phone 2',     'name'=>'Phone2',     'type'=>'text', 'phone'=>true],
  ['label'=>'Email',       'name'=>'Email',      'type'=>'email'],
  ['label'=>'Remarks',     'name'=>'Remarks',    'type'=>'textarea', 'rows'=>3],
];

$showAdmin = true;
$showActive = true;

require __DIR__ . '/../shared/form_base.php';
