<?php
/** @var array $model */
/** @var array $errors */
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
if (!isset($errors) || !is_array($errors)) { $errors = []; }

$isEdit = !empty($model['Id']);
$pageTitle  = $isEdit ? 'Edit Town Meetings and Reports' : 'New Town Meetings and Reports';
$baseUrl    = App\Helpers\url('/townmeetingsandreports');
$formAction = App\Helpers\url($isEdit ? '/townmeetingsandreports/update' : '/townmeetingsandreports/store');

/** Fields for shared/form_base.php */
$fields = [
  ['label'=>'Year'        , 'name'=>'Year'        , 'type'=>'year', 'required' => true],
  ['label'=>'MeetingDate' , 'name'=>'MeetingDate' , 'type'=>'date', 'required' => true],
  ['label'=>'Warrant Url' , 'name'=>'WarrantUrl'  , 'type'=>'text', 'url'=>true, 'pattern'=>'https?://.+'],
  ['label'=>'Meeting Url' , 'name'=>'MeetingUrl'  , 'type'=>'text', 'url'=>true, 'pattern'=>'https?://.+']
];

/** IMPORTANT: no Active column on this table */
$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
