<?php
// $model : current values (create/edit); keys: Id, Name, Document
// $page_title : title string

$isEdit = !empty($model['Id']);
$action = $isEdit ? '/taxmaps/update' : '/taxmaps/store';
$baseUrl        = App\Helpers\url('/taxmaps');
$entitySingular = 'Tax Map';
$parentTable = 'taxmaps';
$pageTitle      = !empty($model['Id']) ? 'Edit Tax Map': 'New Tax Map';

$formAction     = App\Helpers\url(!empty($model['Id']) ? '/taxmaps/update' : '/taxmaps/store');

$fields = [
    [
        'type'     => 'text',
        'name'     => 'Name',
        'required' => true,
        'label'    =>'Name',
        'value'    => $model['Name'] ?? '',
    ],
    [
        'type'  => 'url',
        'name'  => 'Document',
        'required' => true,
        'label' => 'Url (choose a file to build the Url)',
        'value' => $model['Document'] ?? '',
        'url'   =>true
    ],
];

$cfg = [
    'title'       => $page_title,
    'action'      => $action,
    'method'      => 'POST',
    'submit_text' => $isEdit ? 'Update' : 'Create',
    'cancel_url'  => '/taxmaps',
    'fields'      => $fields,
];

$showActive = false;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
