<?php
$title = $title ?? 'Home';
include __DIR__ . '/layout.php';
?>

<style>
/* Front-page-only background pattern (subtle tiles) */
.hero-tiles{
  background-image: radial-gradient(rgba(255,255,255,0.7) 1px, transparent 1px),
                    radial-gradient(rgba(255,255,255,0.7) 1px, transparent 1px);
  background-position: 0 0, 10px 10px;
  background-size: 20px 20px;
  background-color: #0b3b5a; /* deep brand blue */
  color: #fff;
}
.hero-tiles a{ color: #fffbcc; }
.hero-tiles .lead{ color: #e9eef5; }
</style>

<section class="hero-tiles py-5 mb-4">
  <div class="container">
    <div class="row align-items-center g-4">
      <div class="col-lg-7">
        <h1 class="display-5 fw-bold mb-2">Town of Cushing, Maine</h1>
        <p class="lead fw-bold mb-3">Welcome to the administrative portal, where you can add, edit, update and delete important town information.</p>
        <?php if (!empty($town) && !empty($town['Remarks'])): ?>
          <p class="fw-bold mb-0"><em><?= htmlspecialchars($town['Remarks']) ?></em></p>
        <?php endif; ?>
      </div>
      <div class="col-lg-5">
        <div class="card shadow border-0">
          <div class="card-body">
            <h5 class="card-title mb-3">Today's Hours</h5>
            <?php if (!empty($hours)): ?>
              <ul class="list-group list-group-flush">
                <?php foreach ($hours as $h): ?>
                  <li class="list-group-item">
                    <span class="fw-semibold">
                      <?= $h['DeptName'] ? htmlspecialchars($h['DeptName']).': ' : '' ?>
                    </span>
                    <?= htmlspecialchars(substr((string)$h['OpenTime'],0,5)) ?>–<?= htmlspecialchars(substr((string)$h['CloseTime'],0,5)) ?>
                  </li>
                <?php endforeach; ?>
              </ul>
            <?php else: ?>
              <div class="text-muted">Closed today.</div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="container pb-5">
  <div class="row g-4">
    <div class="col-lg-7">
      <div class="card shadow-sm border-0">
        <div class="card-body">
          <h5 class="card-title mb-3">Town Office</h5>
          <?php if ($town): ?>
            <address class="mb-2">
              <strong><?= htmlspecialchars($town['Name']) ?></strong><br>
              <?= htmlspecialchars($town['Address1']) ?><?= $town['Address2'] ? ', '.htmlspecialchars($town['Address2']) : '' ?><br>
              <?= htmlspecialchars($town['Town']) ?>, <?= htmlspecialchars($town['State']) ?> <?= htmlspecialchars($town['Zip']) ?><br>
              Phone: <?= htmlspecialchars($town['Phone1']) ?>
              <?php if($town['Phone2']): ?> · Fax: <?= htmlspecialchars($town['Phone2']) ?><?php endif; ?><br>
              <?php if($town['Email']): ?>Email: <a href="mailto:<?= htmlspecialchars($town['Email']) ?>"><?= htmlspecialchars($town['Email']) ?></a><?php endif; ?>
            </address>
          <?php else: ?>
            <p>No Town record yet.</p>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-lg-5">
      <div class="card shadow-sm border-0">
        <div class="card-body">
          <h5 class="card-title mb-3">Quick Links</h5>
          <div class="list-group">
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/') ?>">Home</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/announcements') ?>">Announcements</a>
            <!--a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/boardlinks') ?>">BoardLinks</a-->
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/boardsandcommittees') ?>">Boards/Committees</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/boardsandcommitteemembers') ?>">Board or Committee Members</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/boardmeetings') ?>">Board Meetings</a>
            <!--a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/boardschedulerules') ?>">BoardScheduleRules</a-->
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/community') ?>">Community</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/events') ?>">Events</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/fireandsafety') ?>">Fire/Safety</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/information') ?>">Information</a>
            <!--a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/officerpositions') ?>">OfficerPositions</a-->
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/ordinancesregulationsforms') ?>">Ordinances/Regulations/Forms</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/resources') ?>">Resources</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/taxmaps') ?>">TaxMaps</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/town') ?>">Town Info</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/townmeetingsandreports') ?>">Town Meetings/Reports</a>
            <a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/townstaffpositions') ?>">Town Staff</a>
            <!--a class="list-group-item list-group-item-action" href="<?= App\Helpers\url('/login') ?>">Login</a-->
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/layout_footer.php'; ?>
