<?php
// ---- guard at top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
$isEdit = !empty($model['Id']);
// -----------------------

$entitySingular = 'Community';
$pageTitle = sprintf(
    '%s Community Record',
    $isEdit ? 'Edit' : 'New'
);

$baseUrl    = App\Helpers\url('/community');
$formAction = App\Helpers\url($isEdit ? '/community/update' : '/community/store');

use App\Models\DB;

$pdo = DB::pdo();

// ✅ Pull existing categories for datalist (self-learning)
$stmt = $pdo->query("
    SELECT DISTINCT Category 
    FROM community 
    WHERE Category IS NOT NULL AND Category <> '' 
    ORDER BY Category
");
$dropdownOptions = $stmt->fetchAll(\PDO::FETCH_COLUMN);

// other dropdowns etc. can remain as is

$fields = [
  ['label'=>'Organization Name', 'name'=>'Name', 'type'=>'text', 'required'=>true],
  [
      'label' => 'Category',
      'name'  => 'Category',
      'type'  => 'datalist',   // tell renderer this field uses a datalist
      'list'  => 'dropdownOptions',  // ID of the <datalist>
      'help'  => 'Start typing and select an existing Category, or keep typing to create a new one'
  ],
  ['label'=>'Address 1',         'name'=>'Address1',         'type'=>'text'],
  ['label'=>'Address 2',         'name'=>'Address2',         'type'=>'text'],
  ['label'=>'Town',              'name'=>'Town',             'type'=>'text'],
  ['label'=>'State',             'name'=>'State',            'type'=>'text'],
  ['label'=>'Zip',               'name'=>'Zip',              'type'=>'text'],
  ['label'=>'Phone',             'name'=>'Phone',            'type'=>'text', 'phone'=>true],
  ['label'=>'Hours',             'name'=>'Hours',            'type'=>'text'],
  ['label'=>'Description',       'name'=>'Description',      'type'=>'text'],
  ['label'=>'Notes',             'name'=>'Notes',            'type'=>'text'],
];

$showActive  = true;
$showSpecial = false;

// Optional header buttons (rendered by shared/form_base.php if present)
$headerButtons = [];

if (!empty($model['Id'])) {
  // Parent must match your Attachments constraint list exactly (e.g., 'Resources')
  $headerButtons[] =
    '<a class="btn btn-secondary" href="' .
    App\Helpers\url('/attachments?parent=Community&id=' . urlencode((string)$model['Id']) . '&ptitle=' . urlencode((string)$model['Name'])) .
    '">Manage attachments</a>';
}
?>

<!-- ✅ HTML datalist definition (browser-native dropdown + free text) -->
<datalist id="dropdownOptions">
<?php foreach ($dropdownOptions as $opt): ?>
  <option value="<?= htmlspecialchars($opt, ENT_QUOTES, 'UTF-8') ?>">
<?php endforeach; ?>
</datalist>

<?php
require __DIR__ . '/../shared/form_base.php';
?>
