<?php
// $rows    : result set from controller
// $boards  : dropdown options
// $page_title : title string

//var_dump($_GET);
//die();

$pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
$pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
$pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
$ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');

$baseUrl        = App\Helpers\url('/boardmeetingminutes');

//$pageTitle      = 'Meeting Minutes';
$pageTitle = 'Meeting Minutes' . ($ptitle ? ' (' . htmlspecialchars($ptitle) . ')' : '');
$entityPlural   = 'Meeting Minutes';
$entitySingular = 'Meeting Minutes';

$listColumns = [
  ['label'=>'Name',                 'field'=>'BoardName', 'link'=>true],
  ['label'=>'Meeting Date',           'field'=>'Date'],
  ['label'=>'Agenda URL',           'field'=>'AgendaUrl', 'type' => 'Url'],
  ['label'=>'Approved Minutes Url', 'field'=>'ApprovedMinutesUrl', 'type' => 'Url'],
  ['label'=>'Recording Url', 'field'=>'RecordingUrl', 'type' => 'Url'],
];


$cfg = [
    'title'       => $page_title,
    'create_url'  => '/boardmeetingminutes/create',
    'edit_url'    => '/boardmeetingminutes/edit',   // expects ?id={Id}
    'delete_url'  => '/boardmeetingminutes/delete', // POST with Id
    'link_field'  => 'PrettyDate',                  // clickable link text
    'columns'     => [
        ['header' => 'Board',         'field' => 'BoardName'],
        ['header' => 'Date of Meeting','field' => 'PrettyDate'],
        ['header' => 'Agenda',        'field' => 'AgendaUrl',          'type' => 'url'],
        ['header' => 'Approved Minutes','field' => 'ApprovedMinutesUrl','type' => 'url'],
        ['header' => 'Recording',     'field' => 'RecordingUrl',       'type' => 'url'],
    ],
    'rows'        => array_map(function ($r) {
        $r['PrettyDate'] = date('F j, Y', strtotime($r['Date']));
        return $r;
    }, $rows),
    // Optional small filter UI rendered above the list
    'filters_html' => (function() use ($boards) {
        $sel = isset($_GET['board']) ? (int)$_GET['board'] : 0;
        ob_start(); ?>
        <form method="get" action="/boardmeetingminutes" class="mb-3 d-flex gap-2 align-items-center">
            <label for="f_board" class="mb-0">Board:</label>
            <select id="f_board" name="board" class="form-select" style="max-width:380px">
                <option value="">(All)</option>
                <?php foreach ($boards as $b): ?>
                    <option value="<?= (int)$b['Id'] ?>" <?= $sel===(int)$b['Id']?'selected':'' ?>>
                        <?= htmlspecialchars($b['BoardName']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button class="btn btn-primary" type="submit">Filter</button>
        </form>
        <?php return ob_get_clean();
    })(),
];

$showActive = false;
$showSpecial = false;

require __DIR__ . '/../shared/list_base.php';
