<?php
namespace App;

class Router {
    private array $routes = ['GET'=>[], 'POST'=>[]];

    public function get(string $path, callable $handler): void {
        $this->routes['GET'][$this->normalize($path)] = $handler;
    }
    public function post(string $path, callable $handler): void {
        $this->routes['POST'][$this->normalize($path)] = $handler;
    }
public function dispatch(string $uri, string $method): void {
    // Detect base path (e.g., /TownOfCushingME/public) and script name (/index.php)
    $script = str_replace('\\','/', $_SERVER['SCRIPT_NAME'] ?? '');
    $base   = rtrim(dirname($script), '/');        // '' or '/TownOfCushingME/public'
    $scriptName = '/' . basename($script);         // '/index.php'

    // Parse request path
    $path = parse_url($uri, PHP_URL_PATH) ?? '/';

    // Strip base dir prefix if present
    if ($base && strpos($path, $base) === 0) {
        $path = substr($path, strlen($base));
        if ($path === '') $path = '/';
    }

    // If the request includes the script name, normalize:
    //   /index.php           -> /
    //   /index.php/foo/bar   -> /foo/bar
    if ($path === $scriptName) {
        $path = '/';
    } elseif (strpos($path, $scriptName . '/') === 0) {
        $path = substr($path, strlen($scriptName));
        if ($path === '') $path = '/';
    }

    $path = $this->normalize($path);

    $handler = $this->routes[$method][$path] ?? null;
    if (!$handler) {
        http_response_code(404);
        ob_start(); include __DIR__ . "/Views/errors/404.php"; echo ob_get_clean();
        return;
    }
    try {
        echo call_user_func($handler);
    } catch (\Throwable $e) {
        \App\Helpers\log_error($e);
        http_response_code(500);
        ob_start(); include __DIR__ . "/Views/errors/500.php"; echo ob_get_clean();
    }
}
    private function normalize(string $path): string {
        $path = rtrim($path, '/');
        return $path === '' ? '/' : $path;
    }
}
