<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

//fix this, category should be  dropdown

class OrdinancesRegulationsFormsController
{
    public static function index(): string
    {
        $pdo = DB::pdo();
        $cat = trim($_GET['category'] ?? '');
        $q   = trim($_GET['q'] ?? '');

        $sql = "SELECT Id, Category, Title, Summary, SortOrder, IsActive, CreatedAt, CreatedBy
                  FROM ordinancesregulationsforms
                 WHERE 1=1";
        $args = [];

        if ($cat !== '') {
            $sql .= " AND Category = ?";
            $args[] = $cat;
        }
        if ($q !== '') {
            $like = "%{$q}%";
            $sql .= " AND (Title LIKE ? OR Summary LIKE ?)";
            array_push($args, $like, $like);
        }

        $sql .= " ORDER BY Category, SortOrder, Title";
        $stmt = $pdo->prepare($sql);
        $stmt->execute($args);
        $rows = $stmt->fetchAll();

        ob_start();
        $title = 'Ordinances / Regulations / Forms';
        include __DIR__ . '/../Views/ordinancesregulationsforms/list.php';
        return ob_get_clean();
    }

    public static function create(): string
    {
        $model = [
            'Id' => 0,
            'Category' => '', 'Title' => '', 'Summary' => '',
            'SortOrder' => 0, 'IsActive' => 1,
        ];
        $errors = [];
        ob_start();
        $title = 'New OrdinancesRegulationsForms Item';
        include __DIR__ . '/../Views/ordinancesregulationsforms/form.php';
        return ob_get_clean();
    }

    public static function store(): void
    {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();

        $data = [
            'Category'  => trim($_POST['Category'] ?? ''),
            'Title'     => trim($_POST['Title'] ?? ''),
            'Summary'   => trim($_POST['Summary'] ?? ''),
            'SortOrder' => (int)($_POST['SortOrder'] ?? 0),
            'IsActive'  => isset($_POST['IsActive']) ? 1 : 0,
        ];

        $errors = [];
        if ($data['Category'] === '') $errors[] = 'Category is required.';
        if ($data['Title'] === '')    $errors[] = 'Title is required.';

        if ($errors) {
            $model = array_merge(['Id'=>0], $data);
            ob_start();
            $title = 'New OrdinancesRegulationsForms Item';
            include __DIR__ . '/../Views/ordinancesregulationsforms/form.php';
            $html = ob_get_clean();
            echo $html;
            return;
        }

        //Save file/url
        $parentTable = 'ordinancesregulationsforms';
        $upload = \App\Helpers\handleupload('attachment_Title', $parentTable);
        if ($upload) {
            // Build full URL using config PrependURL
            $data['Title'] = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }

        $sql = "INSERT INTO ordinancesregulationsforms
                   (Category, Title, Summary, SortOrder, IsActive, CreatedAt, CreatedBy)
                VALUES (?,?,?,?,?, NOW(3), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Category'], $data['Title'], $data['Summary'], $data['SortOrder'], $data['IsActive'],
            $createdBy
        ]);
        $id = (int)$pdo->lastInsertId();

        audit('OrdinancesRegulationsForms', 'create', $id, ['after' => $data]);
        redirect('/ordinancesregulationsforms');
    }

    public static function edit(): string
    {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM ordinancesregulationsforms WHERE Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();

        if (!$model) {
            http_response_code(404);
            return "Record not found";
        }

        $errors = [];
        ob_start();
        $title = 'Edit OrdinancesRegulationsForms Item';
        include __DIR__ . '/../Views/ordinancesregulationsforms/form.php';
        return ob_get_clean();
    }

    public static function update(): void
    {
        csrf_verify();
        $id  = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM ordinancesregulationsforms WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Category'  => trim($_POST['Category'] ?? ''),
            'Title'     => trim($_POST['Title'] ?? ''),
            'Summary'   => trim($_POST['Summary'] ?? ''),
            'SortOrder' => (int)($_POST['SortOrder'] ?? 0),
            'IsActive'  => isset($_POST['IsActive']) ? 1 : 0,
        ];

        $errors = [];
        if ($data['Category'] === '') $errors[] = 'Category is required.';
        if ($data['Title'] === '')    $errors[] = 'Title is required.';

        if ($errors) {
            $model = array_merge(['Id'=>$id], $data);
            ob_start();
            $title = 'Edit OrdinancesRegulationsForms Item';
            include __DIR__ . '/../Views/ordinancesregulationsforms/form.php';
            $html = ob_get_clean();
            echo $html;
            return;
        }

        //Save file/url
        \App\Helpers\log_info("before upload: {$data['Title']}");
        $parentTable = 'ordinancesregulationsforms';
        $upload = \App\Helpers\handleupload('attachment_Title', $parentTable);
        if ($upload) {
            // Build full URL using config PrependURL
            $data['Title'] = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }
        \App\Helpers\log_info("after upload: {$data['Title']}");

        $sql = "UPDATE ordinancesregulationsforms
                   SET Category=?, Title=?, Summary=?, SortOrder=?, IsActive=?
                 WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Category'], $data['Title'], $data['Summary'], $data['SortOrder'], $data['IsActive'],
            $id
        ]);

        audit('OrdinancesRegulationsForms', 'update', $id, ['before' => $before, 'after' => $data]);
        redirect('/ordinancesregulationsforms');
    }

    public static function delete(): void
    {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM ordinancesregulationsforms WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];

        $stmt = $pdo->prepare("DELETE FROM ordinancesregulationsforms WHERE Id=?");
        $stmt->execute([$id]);

        audit('OrdinancesRegulationsForms', 'delete', $id, ['before' => $row]);
        redirect('/ordinancesregulationsforms');
    }
}
