<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class OfficerPositionsController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT Id, Name FROM officerpositions ORDER BY Name";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'OfficerPositions';
        include __DIR__ . '/../Views/officerpositions/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
        ob_start();
        $title = 'New OfficerPositions';
        include __DIR__ . '/../Views/officerpositions/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $data = [
            'Name' => trim((string)($_POST['Name'] ?? ''))
        ];

        $sql = "INSERT INTO officerpositions (Name) VALUES (?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([trim((string)($_POST['Name'] ?? ''))]);

        $id = (int)$pdo->lastInsertId();
        audit('OfficerPositions','create',$id,$data);
        redirect('/officerpositions');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM officerpositions WHERE Id=?");
        $stmt->execute([$id]);
        $resource = $stmt->fetch();
        if (!$resource) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/officerpositions/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM officerpositions WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Name' => trim((string)($_POST['Name'] ?? ''))
        ];
        $sql = "UPDATE officerpositions SET Name=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([trim((string)($_POST['Name'] ?? '')), $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('OfficerPositions','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/officerpositions');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM officerpositions WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM officerpositions WHERE Id=?");
        $stmt->execute([$id]);
        audit('OfficerPositions','delete',$id,['before'=>$row]);
        redirect('/officerpositions');
    }
}
