<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class InformationController
{
    public static function index(): string
    {
        $pdo = DB::pdo();
        $q  = trim($_GET['q'] ?? '');
        $cat = trim($_GET['category'] ?? '');

        $sql = "SELECT Id, Category, Role, ContactName, Location, MailAddress,
                       PhonePrimary, Email, Hours, Notes, IsActive, CreatedAt, CreatedBy
                  FROM information
                 WHERE 1=1";
        $args = [];

        if ($cat !== '') {
            $sql .= " AND Category = ?";
            $args[] = $cat;
        }
        if ($q !== '') {
            $like = "%{$q}%";
            $sql .= " AND (Role LIKE ? OR ContactName LIKE ? OR Email LIKE ? OR PhonePrimary LIKE ? OR Notes LIKE ?)";
            array_push($args, $like, $like, $like, $like, $like);
        }

        $sql .= " ORDER BY Category, Role, ContactName";
        $stmt = $pdo->prepare($sql);
        $stmt->execute($args);
        $rows = $stmt->fetchAll();

        ob_start();
        $title = 'Information';
        include __DIR__ . '/../Views/information/list.php';
        return ob_get_clean();
    }

    public static function create(): string
    {
        $model = [
            'Id' => 0,
            'Category' => '', 'Role' => '', 'ContactName' => '',
            'Location' => '', 'MailAddress' => '',
            'PhonePrimary' => '', 'Email' => '',
            'Hours' => '', 'Notes' => '',
            'IsActive' => 1,
        ];
        $errors = [];
        ob_start();
        $title = 'New Information';
        include __DIR__ . '/../Views/information/form.php';
        return ob_get_clean();
    }

    public static function store(): void
    {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();

        $data = [
            'Category'     => trim($_POST['Category'] ?? ''),
            'Role'         => trim($_POST['Role'] ?? ''),
            'ContactName'  => trim($_POST['ContactName'] ?? ''),
            'Location'     => trim($_POST['Location'] ?? ''),
            'MailAddress'  => trim($_POST['MailAddress'] ?? ''),
            'PhonePrimary' => trim($_POST['PhonePrimary'] ?? ''),
            'Email'        => trim($_POST['Email'] ?? ''),
            'Hours'        => trim($_POST['Hours'] ?? ''),
            'Notes'        => trim($_POST['Notes'] ?? ''),
            'IsActive'     => isset($_POST['IsActive']) ? 1 : 0,
        ];

        // Basic validation (mirror your minimal pattern)
        $errors = [];
        if ($data['Category'] === '') $errors[] = 'Category is required.';
        if ($data['Role'] === '') $errors[] = 'Role is required.';

        if ($errors) {
            $model = array_merge(['Id'=>0], $data);
            ob_start();
            $title = 'New Information';
            include __DIR__ . '/../Views/information/form.php';
            $html = ob_get_clean();
            echo $html;
            return;
        }

        $sql = "INSERT INTO information
                   (Category, Role, ContactName, Location, MailAddress,
                    PhonePrimary, Email, Hours, Notes, IsActive, CreatedAt, CreatedBy)
                VALUES (?,?,?,?,?,?,?,?,?, ?, NOW(3), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Category'], $data['Role'], $data['ContactName'], $data['Location'], $data['MailAddress'],
            $data['PhonePrimary'], $data['Email'], $data['Hours'], $data['Notes'], $data['IsActive'],
            $createdBy
        ]);
        $id = (int)$pdo->lastInsertId();
        audit('Information', 'create', $id, ['after' => $data]);
        redirect('/information');
    }

    public static function edit(): string
    {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM information WHERE Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();

        if (!$model) {
            http_response_code(404);
            return "Information record not found";
        }

        $errors = [];
        ob_start();
        $title = 'Edit Information';
        include __DIR__ . '/../Views/information/form.php';
        return ob_get_clean();
    }

    public static function update(): void
    {
        csrf_verify();
        $id  = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM information WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Category'     => trim($_POST['Category'] ?? ''),
            'Role'         => trim($_POST['Role'] ?? ''),
            'ContactName'  => trim($_POST['ContactName'] ?? ''),
            'Location'     => trim($_POST['Location'] ?? ''),
            'MailAddress'  => trim($_POST['MailAddress'] ?? ''),
            'PhonePrimary' => trim($_POST['PhonePrimary'] ?? ''),
            'Email'        => trim($_POST['Email'] ?? ''),
            'Hours'        => trim($_POST['Hours'] ?? ''),
            'Notes'        => trim($_POST['Notes'] ?? ''),
            'IsActive'     => isset($_POST['IsActive']) ? 1 : 0,
        ];

        $errors = [];
        if ($data['Category'] === '') $errors[] = 'Category is required.';
        if ($data['Role'] === '') $errors[] = 'Role is required.';

        if ($errors) {
            $model = array_merge(['Id'=>$id], $data);
            ob_start();
            $title = 'Edit Information';
            include __DIR__ . '/../Views/information/form.php';
            $html = ob_get_clean();
            echo $html;
            return;
        }

        $sql = "UPDATE information
                   SET Category=?, Role=?, ContactName=?, Location=?, MailAddress=?,
                       PhonePrimary=?, Email=?, Hours=?, Notes=?, IsActive=?
                 WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Category'], $data['Role'], $data['ContactName'], $data['Location'], $data['MailAddress'],
            $data['PhonePrimary'], $data['Email'], $data['Hours'], $data['Notes'], $data['IsActive'],
            $id
        ]);

        audit('Information', 'update', $id, ['before' => $before, 'after' => $data]);
        redirect('/information');
    }

    public static function delete(): void
    {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM information WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];

        $stmt = $pdo->prepare("DELETE FROM information WHERE Id=?");
        $stmt->execute([$id]);

        audit('Information', 'delete', $id, ['before' => $row]);
        redirect('/information');
    }
}
