<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

class FireAndSafetyController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT * FROM fireandsafety ORDER BY Category";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'FireAndSafety';
        include __DIR__ . '/../Views/fireandsafety/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
        ob_start();
        $title = 'New FireAndSafety';
        include __DIR__ . '/../Views/fireandsafety/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $data = [
            'Category'      => trim((string)($_POST['Category'     ] ?? '')),   
            'Position'      => trim((string)($_POST['Position'     ] ?? '')),
            'Name'          => trim((string)($_POST['Name'         ] ?? '')),
            'Email'         => trim((string)($_POST['Email'        ] ?? '')),
            'Url'           => trim((string)($_POST['Url'          ] ?? '')),
            'PhoneLocation' => trim((string)($_POST['PhoneLocation'] ?? '')),
            'Phone'         => trim((string)($_POST['Phone'        ] ?? '')),
            'Notes'         => trim((string)($_POST['Notes'        ] ?? '')),
            'IsActive'      => (isset($_POST['IsActive']) ? 1 : 0),
            'CreatedAt'     => trim((string)($_POST['CreatedAt'    ] ?? '')),
            'CreatedBy' => $createdBy
        ];

        $sql = "INSERT INTO fireandsafety (Category, Position, Name, Email, Url, PhoneLocation, Phone, Notes, IsActive, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
          $data['Category'     ],
          $data['Position'     ],
          $data['Name'         ],
          $data['Email'        ],
          $data['Url'          ],
          $data['PhoneLocation'],
          $data['Phone'        ],
          $data['Notes'        ],
          $data['IsActive'     ],
          $data['CreatedBy'    ]
        ]);

        $id = (int)$pdo->lastInsertId();
        audit('FireAndSafety','create',$id,$data);
        redirect('/fireandsafety');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM fireandsafety WHERE Id=?");
        $stmt->execute([$id]);
        $resource = $stmt->fetch();
        if (!$resource) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/fireandsafety/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM fireandsafety WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Category'      => trim((string)($_POST['Category'     ] ?? '')),   
            'Position'      => trim((string)($_POST['Position'     ] ?? '')),
            'Name'          => trim((string)($_POST['Name'         ] ?? '')),
            'Email'         => trim((string)($_POST['Email'        ] ?? '')),
            'Url'           => trim((string)($_POST['Url'          ] ?? '')),
            'PhoneLocation' => trim((string)($_POST['PhoneLocation'] ?? '')),
            'Phone'         => trim((string)($_POST['Phone'        ] ?? '')),
            'Notes'         => trim((string)($_POST['Notes'        ] ?? '')),
            'IsActive'      => (isset($_POST['IsActive']) ? 1 : 0)
        ];
        $sql = "UPDATE fireandsafety SET Category=?, Position=?, Name=?, Email=?, Url=?, PhoneLocation=?, Phone=?, Notes=?, IsActive=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
          $data['Category'     ],
          $data['Position'     ],
          $data['Name'         ],
          $data['Email'        ],
          $data['Url'          ],
          $data['PhoneLocation'],
          $data['Phone'        ],
          $data['Notes'        ],
          $data['IsActive'     ],
          $id
        ]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('FireAndSafety','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/fireandsafety');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM fireandsafety WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM fireandsafety WHERE Id=?");
        $stmt->execute([$id]);
        audit('FireAndSafety','delete',$id,['before'=>$row]);
        redirect('/fireandsafety');
    }
}
