# TheTown – Minimal PHP Skeleton (IIS → LAMP portable)

This is a tiny, dependency‑free PHP skeleton you can run under **IIS + FastCGI** (today) 
and later move to **LAMP** with minimal changes. No Composer libraries required.

## Requirements
- PHP 7.4+ (PHP 8.x recommended)
- On Windows/IIS + SQL Server: `pdo_sqlsrv` extension enabled
- On Linux/Apache + MySQL: `pdo_mysql` extension enabled
- URL rewriting enabled (IIS URL Rewrite / Apache .htaccess)

## Configure
Edit `config/config.php` (or set environment variables). Important keys:
- DB_DRIVER: `sqlsrv` or `mysql`
- DB_HOST, DB_DATABASE, DB_USERNAME, DB_PASSWORD
- APP_ENV: `prod` or `dev`
- APP_URL: base URL for redirects

## Run on IIS
- Point your IIS site **physical path to** `public/`
- Ensure PHP FastCGI is configured and `pdo_sqlsrv` is loaded (phpinfo)
- Confirm URL Rewrite is installed (the included `web.config` handles routing)

## Move to LAMP
- Copy all files, keep `public/` as the web root
- Ensure `.htaccess` is read by Apache (AllowOverride All on the vhost)
- Switch `DB_DRIVER=mysql` and fill MySQL credentials in `config/config.php`

## Minimal features included
- Very small router (`app/Router.php` + `routes.php`)
- Views/templates with a single `layout.php`
- PDO DB layer (`app/Models/DB.php`) that flips between SQL Server and MySQL
- CSRF helper (`app/Helpers/csrf.php`)
- Simple controllers:
  - `HomeController` : shows Town + today’s Hours
  - `ResourcesController` : list/create/edit/delete Resources (basic CRUD)
  - `AuthController` : very simple session login (hardcoded user by default – replace later)

## Security notes
- CSRF tokens on all forms (basic helper)
- Uses prepared statements for DB writes
- You should replace the demo login with a proper users table and password hashing

## Routes (examples)
- `/` → home
- `/resources` → list
- `/resources/create` → form
- `/resources/store` → POST create
- `/resources/edit?id=##` → form
- `/resources/update` → POST update
- `/resources/delete?id=##` → POST delete (with CSRF)

## Next steps
- Replace demo login with real `users`, `roles`, and `permissions`
- Add audit logging (who changed what)
- Add server‑side validation and friendlier errors


## Migrations

Run the audit log migration in SQL Server:

```sql
:r database/migrations/001_create_audit_log.sql
```

Or paste the contents of `database/migrations/001_create_audit_log.sql` into SSMS and execute against the `TheTown` database.
