<h2 class="h5">Town Meetings & Reports</h2>

<?php if (empty($townmeetingsandreports)): ?>
  <p class="text-muted mb-0">No meetings or reports listed.</p>
<?php else: ?>
  <div class="row g-3">
    <?php foreach ($townmeetingsandreports as $t): ?>
      <div class="col-12 col-md-6 col-lg-4">
        <article class="card h-100">
          <div class="card-body text-center">

            <h3 class="h6 mb-2">
              Year: <?= esc($t['Year']) ?>
            </h3>

            <?php if (!empty($t['MeetingDate'])): ?>
              <p class="mb-2">
                Meeting Date:
                <?= date('M j, Y', strtotime($t['MeetingDate'])) ?>
              </p>
            <?php endif; ?>

            <?php if (!empty($t['WarrantUrl'])): ?>
              <p class="mb-1">
                <a href="<?= esc($t['WarrantUrl']) ?>" target="_blank" class="link-success text-decoration-none">
                  Warrant Document
                </a>
              </p>
            <?php endif; ?>

            <?php if (!empty($t['MeetingUrl'])): ?>
              <p class="mb-0">
                <a href="<?= esc($t['MeetingUrl']) ?>" target="_blank" class="link-success text-decoration-none">
                  Meeting Document
                </a>
              </p>
            <?php endif; ?>

          </div>
        </article>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
