<?php
// /WebSite/boardsandcommittees/show.php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../app/Models/DB.php';
require_once __DIR__ . '/../app/Helpers/Helpers.php';

use App\Models\DB;
use App\Helpers\HELP;

// Get id
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$pdo=DB::pdo();

// Fetch record
$stmt = $pdo->prepare("
    SELECT CommitteeName, Description, MeetingScheduleModel,
           Email, BylawsUrl, Remarks
    FROM boardsandcommittees
    WHERE Id = ?
");
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch Members
$stmt = $pdo->prepare("
    SELECT m.*, op.Name AS OfficerPositionName
    FROM boardsandcommitteemembers m
    LEFT JOIN officerpositions op ON op.Id = m.OfficerPositionID
    WHERE m.BoardId = ?
    ORDER BY op.Name, m.PersonName
");
$stmt->execute([$id]);
$members = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Meetings
$stmt = $pdo->prepare("
    SELECT *
    FROM boardmeetingminutes
    WHERE BoardId = ?
    ORDER BY MeetingDate DESC
");
$stmt->execute([$id]);
$meetings = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Schedule Rules
$stmt = $pdo->prepare("
    SELECT *
    FROM boardschedulerules
    WHERE BoardId = ?
    ORDER BY Id DESC
");
$stmt->execute([$id]);
$scheduleRules = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$row) {
    http_response_code(404);
    echo "<div class='container py-5'><p class='text-danger'>Board or committee not found.</p></div>";
    exit;
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?= HELP::esc($row['CommitteeName']) ?> – Town of Cushing</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/WebSite/style.css">
</head>
<body class="bg-light">

<div class="container" style="margin-top: 2rem; max-height: 90vh; overflow-y: auto;">
<!--div class="container" style="margin-top: 2rem;"-->
  <div class="row justify-content-center">
    <div class="col-12 col-lg-10">
      <article class="card shadow-sm">
        <div class="card-body">

          <a href="<?= HELP::url('/WebSite') ?>"
             class="btn btn-outline-secondary btn-sm">
             ← Back
          </a>

          <h1 class="h4 text-center mb-4"><?= HELP::esc($row['CommitteeName']) ?></h1>

          <div class="row">
            <!-- ================== LEFT COLUMN ================== -->
            <div class="col-md-7">

              <?php if (!empty($row['Description'])): ?>
                <section class="mb-3">
                  <h2 class="h6 text-muted">Description:</h2>
                  <div><?= nl2br(HELP::esc($row['Description'])) ?></div>
                </section>
              <?php endif; ?>

              <?php if (!empty($row['MeetingScheduleModel'])): ?>
                <section class="mb-3">
                  <h2 class="h6 text-muted">Meeting Schedule:</h2>
                  <div><?= nl2br(HELP::esc($row['MeetingScheduleModel'])) ?></div>
                </section>
              <?php endif; ?>

              <?php if (!empty($row['Email'])): ?>
                <section class="mb-3">
                  <h2 class="h6 text-muted">
                    Email:
                    <a href="mailto:<?= HELP::esc($row['Email']) ?>">
                      <?= nl2br(HELP::esc($row['Email'])) ?>
                    </a>
                  </h2>
                </section>
              <?php endif; ?>

              <?php if (!empty($row['BylawsUrl'])): ?>
                <section class="mb-3">
                  <h2 class="h6 text-muted">Bylaws:</h2>
                  <a href="<?= HELP::esc($row['BylawsUrl']) ?>" target="_blank" rel="noopener noreferrer"
                     class="btn btn-outline-primary btn-sm">
                    <?= HELP::esc($row['BylawsUrl']) ?>
                  </a>
                </section>
              <?php endif; ?>

              <?php if (!empty($row['Remarks'])): ?>
                <section class="mb-3">
                  <h2 class="h6 text-muted">Remarks:</h2>
                  <div><?= nl2br(HELP::esc($row['Remarks'])) ?></div>
                </section>
              <?php endif; ?>

              <?php if (!empty($meetings)): ?>
                  <section class="mb-4">
                      <h2 class="h6 text-muted">Meeting Minutes:</h2>

                      <?php
                          $byYear = [];
                          foreach ($meetings as $m) {
                              $year = date('Y', strtotime($m['MeetingDate']));
                              $byYear[$year][] = $m;
                          }

                          krsort($byYear); // newest year first
                      ?>

                      <?php foreach ($byYear as $year => $items): ?>
                          <h4 class="mt-3 mb-2"><?= HELP::esc($year) ?></h4>

                          <?php foreach ($items as $m): ?>
                              <?php
                                  $dateLabel = date('F j, Y', strtotime($m['MeetingDate']));
                                  $url = HELP::esc($m['ApprovedMinutesUrl']);
                              ?>
                              <div class="mb-1">
                                  <a href="<?= $url ?>" target="_blank">
                                      <?= HELP::esc($dateLabel) ?>
                                  </a>
                              </div>
                          <?php endforeach; ?>

                      <?php endforeach; ?>

                  </section>
              <?php endif; ?>
            </div>

            <!-- ================== RIGHT COLUMN (MEMBERS) ================== -->
            <div class="col-md-5">

              <?php if (!empty($members)): ?>
                <section class="mb-4">
                  <h2 class="h6 text-muted">Members</h2>

                  <?php
                    $priorityOrder = [
                        'Chairperson' => 1,
                        'Vice-Chairperson' => 2,
                        'Secretary' => 3
                    ];

                    $sorted = $members;
                    usort($sorted, function($a, $b) use ($priorityOrder) {
                        $pa = trim($a['Remarks'] ?? '');
                        $pb = trim($b['Remarks'] ?? '');

                        $aRank = $priorityOrder[$pa] ?? 999;
                        $bRank = $priorityOrder[$pb] ?? 999;

                        if ($aRank !== $bRank) return $aRank <=> $bRank;
                        return strcasecmp($a['PersonName'], $b['PersonName']);
                    });
                  ?>

                  <div class="ms-2 mt-2">
                    <?php foreach ($sorted as $m): ?>
                      <?php
                        $pos = trim($m['Remarks'] ?? '');
                        $name = HELP::esc($m['PersonName']);
                      ?>

                      <div class="mb-1" style="font-size: 1.05rem;">
                        <?= $name ?>
                        <?php if ($pos): ?>
                          – <?= HELP::esc($pos) ?>
                        <?php endif; ?>
                      </div>

                    <?php endforeach; ?>
                  </div>

                </section>
              <?php endif; ?>

            </div>
          </div> <!-- /row -->
        </div>
      </article>
    </div>
  </div>
</div>

</body>
</html>
