<?php
// $model : current values (create/edit)
// $page_title : title string

$isEdit = !empty($model['Id']);
$action = $isEdit ? '/town/update' : '/town/store';
$baseUrl        = App\Helpers\url('/town');
$entitySingular = 'Town';
$pageTitle      = !empty($model['Id']) ? 'Edit Town Info': 'New Town Info';

$formAction     = App\Helpers\url(!empty($model['Id']) ? '/town/update' : '/town/store');

/* Normalize Active -> IsActive for shared form checkbox */
if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
  $model['IsActive'] = (int)$model['Active'];
}

$fields = [
    [
        'type'     => 'input',
        'name'     => 'Name',
        'required' => true,
        'label'    =>'Name',
        'value'    => $model['Name'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Address1',
        'required' => true,
        'label' => 'Address1',
        'value' => $model['Address1'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Address2',
        'label' => 'Address2',
        'value' => $model['Address2'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Town',
        'required' => true,
        'label' => 'Town',
        'value' => $model['Town'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'State',
        'required' => true,
        'label' => 'State',
        'value' => $model['State'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Zip',
        'required' => true,
        'label' => 'Zip',
        'value' => $model['Zip'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Phone1',
        'required' => true,
        'label' => 'Phone1',
        'phone' =>true,
        'value' => $model['Phone1'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Phone2',
        'label' => 'Phone2',
        'phone' =>true,
        'value' => $model['Phone2'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Email',
        'label' => 'Email',
        'value' => $model['Email'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Website',
        'label' => 'Website',
        'value' => $model['Website'] ?? '',
    ],
    [
        'type'  => 'input',
        'name'  => 'Remarks',
        'label' => 'Remarks',
        'value' => $model['Remarks'] ?? '',
    ],
];

$cfg = [
    'title'       => $page_title,
    'action'      => $action,
    'method'      => 'POST',
    'submit_text' => $isEdit ? 'Update' : 'Create',
    'cancel_url'  => '/town',
    'fields'      => $fields,
];

$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
