<?php /* shared/list_base.php */ ?>
<?php include __DIR__ . '/../layout.php'; ?>

<?php
// ---- Default checkbox visibility ----
// Screens may define $showAdmin, $showActive, $showSpecial.
// If they don't, we supply defaults here, the default being don't show, so any
// screen that wants these to show must add them as $showAdmin = true; etc etc
$showAdmin  = $showAdmin  ?? false;
$showActive = $showActive ?? false;
$showSpecial = $showSpecial ?? false;
?>

<?php use function App\Helpers\url; ?>

<h2><?= htmlspecialchars($pageTitle ?? ($entityPlural ?? 'Items')) ?></h2>
<p>
  <a class="btn btn-primary btn-sm" href="<?= htmlspecialchars($baseUrl) ?>/create">+ New <?= htmlspecialchars($entitySingular ?? 'Item') ?></a>
  <a class="btn btn-secondary btn-sm" href="<?= htmlspecialchars(url('/index.php')) ?>">Home</a>
</p>

<?php include __DIR__ . '/../partials/flash.php'; ?>

<?php if (!empty($cfg['filters_html'])): ?>
    <div class="mb-3">
        <?= $cfg['filters_html'] ?>
    </div>
<?php endif; ?>

<?php
// -------------------- SORTING LOGIC --------------------
$sortCol = $_GET['sort'] ?? null;
$sortDir = $_GET['dir'] ?? 'asc';

$validFields = array_column($listColumns, 'field');

if ($sortCol && in_array($sortCol, $validFields)) {
    usort($rows, function($a, $b) use ($sortCol, $sortDir) {
        $va = $a[$sortCol] ?? '';
        $vb = $b[$sortCol] ?? '';

        if ($va == $vb) return 0;
        if ($sortDir === 'asc') return ($va < $vb) ? -1 : 1;
        return ($va > $vb) ? -1 : 1;
    });
}
// -------------------------------------------------------
?>

<?php if (empty($rows)): ?>
  <p class="text-muted">No records found.</p>
<?php else: ?>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead>
        <tr>
          <?php foreach ($listColumns as $c): ?>
            <?php
              $field = $c['field'];
              $label = $c['label'];

              $isCurrent = ($sortCol === $field);
              $nextDir   = ($isCurrent && $sortDir === 'asc') ? 'desc' : 'asc';
              if ($isCurrent) {
                  $arrow = $sortDir === 'asc' ? ' ▲' : ' ▼';
              } else {
                  $arrow = ' ↕';   // neutral arrow always shown
              }
            ?>
            <th>
              <a href="?sort=<?= urlencode($field) ?>&dir=<?= $nextDir ?>"
                 style="text-decoration:none; color:inherit;">
                <?= htmlspecialchars($label) ?><?= $arrow ?>
              </a>
            </th>
          <?php endforeach; ?>

          <?php if (($showActive ?? true)): ?><th>Active</th><?php endif; ?>
          <?php if (($showSpecial ?? true)): ?><th>Special</th><?php endif; ?>
          <th class="actions">Actions</th>
        </tr>
      </thead>

      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <?php foreach ($listColumns as $c): ?>
            <td>
              <?php if (!empty($c['target'])): ?>
                <a target="_blank" href="<?= htmlspecialchars($r['Document']) ?>"></a>

              <?php elseif (!empty($c['link'])): ?>
                <a href="<?= htmlspecialchars($baseUrl) ?>/edit?id=<?= (int)$r['Id'] ?>">
                  <?= htmlspecialchars($r[$c['field']] ?? '') ?>
                </a>

              <?php else: ?>

                <?php
                  $__field = $c['field'] ?? '';
                  $__label = $c['label'] ?? '';
                  $__val   = trim((string)($r[$__field] ?? ''));

                  if ($__val === '') {
                      // nothing to print
                  } elseif (strcasecmp($__field, 'Document') === 0) {
                      echo '<a href="' . htmlspecialchars($__val) . '" target="_blank" rel="noopener">' . htmlspecialchars($__val) . '</a>';

                  } elseif (str_ends_with($__field, 'Url') || str_ends_with($__label, 'Url')) {
                      echo '<a href="' . htmlspecialchars($__val) . '" target="_blank" rel="noopener">' . htmlspecialchars($__val) . '</a>';

                  } elseif (strcasecmp($__field, 'Email') === 0) {
                      echo '<a href="mailto:' . htmlspecialchars($__val) . '">' . htmlspecialchars($__val) . '</a>';

                  } else {
                      echo htmlspecialchars($__val);
                  }
                ?>

              <?php endif; ?>
            </td>
          <?php endforeach; ?>

          <?php if (($showActive ?? true)): ?>
            <td><?= !empty($r['IsActive']) ? '<span class="badge-yes">Yes</span>' : '<span class="badge-no">No</span>' ?></td>
          <?php endif; ?>

          <?php if (($showSpecial ?? true)): ?>
            <td><?= !empty($r['IsSpecial']) ? '<span class="badge-yes">Yes</span>' : '<span class="badge-no">No</span>' ?></td>
          <?php endif; ?>

          <td class="actions">
            <a class="btn btn-sm btn-outline-primary" href="<?= htmlspecialchars($baseUrl) ?>/edit?id=<?= (int)$r['Id'] ?>">Edit</a>

            <form action="<?= htmlspecialchars($baseUrl) ?>/delete" method="post" class="d-inline"
                  onsubmit="return confirm('Delete this record?');">
              <?= App\Helpers\csrf_field() ?>
              <input type="hidden" name="id" value="<?= (int)$r['Id'] ?>">
              <button class="btn btn-sm btn-outline-danger" type="submit">Delete</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>

    </table>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/../layout_footer.php'; ?>
