<?php
/** Resources form (standardized) */
// Ensure model/errors arrays exist
$model = $model ?? [];
$errors = $errors ?? [];

// Map DB Active -> IsActive expected by shared form
if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
  $model['IsActive'] = (int)$model['Active'];
}

// Defaults
$defaults = [
  'Id' => 0,
  'Title' => '',
  'Url' => '',
  'Category' => '',
  'Description' => '',
  'IsActive' => 1,
];
$model = $model + $defaults;

$isEdit     = ((int)$model['Id'] > 0);
$pageTitle  = $pageTitle ?? ($isEdit ? 'Edit Resource' : 'New Resource');
$entitySingular = 'Resource';
$parentTable = 'Resources';
$baseUrl    = $baseUrl   ?? App\Helpers\url('/resources');
$formAction = $formAction?? App\Helpers\url($isEdit ? '/resources/update' : '/resources/store');

$fields = [
  ['label' => 'Title',       'name' => 'Title',       'type' => 'text',     'required' => true],
  ['label' => 'Url',         'name' => 'Url',         'type' => 'url', 'url'=>true],
  ['label' => 'Category',    'name' => 'Category',    'type' => 'text'],
  ['label' => 'Description', 'name' => 'Description', 'type' => 'textarea', 'rows' => 4],
];
$showActive = true;
$showSpecial = false;

// Optional header buttons (rendered by shared/form_base.php if present)
$headerButtons = [];

if (!empty($model['Id'])) {
  // Parent must match your Attachments constraint list exactly (e.g., 'Resources')
  $headerButtons[] =
    '<a class="btn btn-secondary" href="' .
    App\Helpers\url('/attachments?parent=Resources&id=' . urlencode((string)$model['Id']) . '&ptitle=' . urlencode((string)$model['Title'])) .
    '">Manage attachments</a>';
}

require __DIR__ . '/../shared/form_base.php';

