<?php
// expects: $model, $errors
$entitySingular = 'Item';
$parentTable = 'OrdinancesRegulationsForms';
$isEdit         = !empty($model['Id']);
$pageTitle      = $isEdit ? 'Edit Item' : 'New Item';
$baseUrl        = App\Helpers\url('/ordinancesregulationsforms');
$formAction     = App\Helpers\url($isEdit ? '/ordinancesregulationsforms/update' : '/ordinancesregulationsforms/store');

$fields = [
  // Category is free text in DB, but you can swap to a <select> by updating shared/form_base if desired.
  ['label'=>'Category',  'name'=>'Category',  'type'=>'text', 'required'=>true],
  ['label'=>'Url (choose a file to build the Url)',       'name'=>'Title',     'type'=>'url', 'required'=>true, 'url'=>true],
  ['label'=>'Summary',   'name'=>'Summary',   'type'=>'textarea', 'rows'=>3],
];

$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
