<?php
// expects: $model (assoc array), $errors (array) — same as Announcements form base.
// Controllers should set $model = row, and pass $errors if any.
// ---- add this guard at the very top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
// ----------------------------------------

$entitySingular = 'Information Item';
$pageTitle      = !empty($model['Id']) ? 'Edit Information' : 'New Information';
$baseUrl        = App\Helpers\url('/information');
$formAction     = App\Helpers\url(!empty($model['Id']) ? '/information/update' : '/information/store');

// Map DB id key to the generic 'Id' key used by form_base.php
if (!empty($model['Id']) && empty($model['Id'])) {
  $model['Id'] = (int)$model['Id'];
}

$fields = [
  ['label'=>'Category',     'name'=>'Category',     'type'=>'text',    'required'=>true],
  ['label'=>'Role',         'name'=>'Role',         'type'=>'text',    'required'=>true],
  ['label'=>'Contact Name', 'name'=>'ContactName',  'type'=>'text'],
  ['label'=>'Location',     'name'=>'Location',     'type'=>'text'],
  ['label'=>'Mail Address', 'name'=>'MailAddress',  'type'=>'text'],
  ['label'=>'Phone',        'name'=>'PhonePrimary', 'type'=>'text', 'phone'=>true],
  ['label'=>'Email',        'name'=>'Email',        'type'=>'email'],
  ['label'=>'Hours',        'name'=>'Hours',        'type'=>'textarea', 'rows'=>2],
  ['label'=>'Notes',        'name'=>'Notes',        'type'=>'textarea', 'rows'=>3],
];
$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
