<?php
// ---- add this guard at the very top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
$isEdit = !empty($model['Id']);
// ----------------------------------------

$entitySingular = 'Event';
$pageTitle      = !empty($model['Id']) ? 'Edit Event' : 'New Event';
$baseUrl        = App\Helpers\url('/events');
$formAction     = App\Helpers\url(!empty($model['Id']) ? '/events/update' : '/events/store');

// before $fields
if (!empty($model['StartDateTime'])) {
    $model['StartDateTime'] = str_replace(' ', 'T', substr($model['StartDateTime'], 0, 16)); // YYYY-MM-DDTHH:MM
}
if (!empty($model['EndDateTime'])) {
    $model['EndDateTime'] = str_replace(' ', 'T', substr($model['EndDateTime'], 0, 16));
}

$fields = [
  ['label'=>'Title', 'name'=>'Title', 'type'=>'text', 'required'=>true],
  ['label'=>'Details', 'name'=>'Body', 'type'=>'textarea', 'rows'=>6],
  ['label'=>'Start Date',  'name'=>'StartDate', 'type'=>'date'],
  ['label'=>'End Date',  'name'=>'EndDate', 'type'=>'date'],
  ['label'=>'Location', 'name'=>'Location', 'type'=>'text'],
  ['label'=>'All Day', 'name'=>'AllDay', 'type'=>'text'],

];

$showActive = false;
$showSpecial = false;

// Optional header buttons (rendered by shared/form_base.php if present)
$headerButtons = [];

if (!empty($model['Id'])) {
  // Parent must match your Attachments constraint list exactly (e.g., 'Resources')
  $headerButtons[] =
    '<a class="btn btn-secondary" href="' .
    App\Helpers\url('/attachments?parent=Events&id=' . urlencode((string)$model['Id']) . '&ptitle=' . urlencode((string)$model['Title'])) .
    '">Manage attachments</a>';
}

require __DIR__ . '/../shared/form_base.php';
