<?php
// ---- add this guard at the very top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
$isEdit = !empty($model['Id']);
// ----------------------------------------

$entitySingular = 'Rule';
$pageTitle = sprintf(
    '%s Rule (Board = %s)',
    !empty($model['Id']) ? 'Edit' : 'New',
    $model['CommitteeName'] ?? 'Unknown, set it below in the Board name field'
);
$baseUrl        = App\Helpers\url('/boardschedulerules');
$formAction     = App\Helpers\url(!empty($model['Id']) ? '/boardschedulerules/update' : '/boardschedulerules/store');

//get all possible board names for dropdown in edit mode
use App\Models\DB;

$pdo = DB::pdo();
$stmt = $pdo->query("SELECT DISTINCT CommitteeName FROM BoardsAndCommittees WHERE CommitteeName IS NOT NULL AND CommitteeName <> '' ORDER BY CommitteeName");
$dropdownOptions = $stmt->fetchAll(\PDO::FETCH_COLUMN);

$fields = [
  [
      'label' => 'Board Name',
      'name'  => 'CommitteeName',
      'type'  => 'datalist',   // tell renderer this field uses a datalist
      'list'  => 'dropdownOptions',  // ID of the <datalist>
      'required'=>true,
      'help'  => 'Start typing and select an existing Board or Committee, or keep typing to create a new one'
  ],
  ['label'=>'Details', 'name'=>'Notes', 'type'=>'textarea', 'rows'=>6, 'help'=>'Describe frequency or criteria'],
  ['label'=>'R Rule', 'name'=>'RRule', 'type'=>'text'],
  ['label'=>'Holiday Policy', 'name'=>'HolidayPolicy', 'type'=>'text'],

];
$showActive = true;
$showSpecial = false;
require __DIR__ . '/../shared/form_base.php';
