<?php
/** @var array $model */
/** @var array $errors */
$entitySingular = 'Board/Committee';
$parentTable = 'BoardsAndCommittees';
$isEdit         = !empty($model['Id']);
$pageTitle = ($isEdit ? 'Edit' : 'New') . ' Board/Committee ' . ($model['CommitteeName'] ?? '');
//$pageTitle      = $isEdit ? 'Edit Board/Committee' : 'New Board/Committee';
$baseUrl        = App\Helpers\url('/boardsandcommittees');
$formAction     = App\Helpers\url($isEdit ? '/boardsandcommittees/update' : '/boardsandcommittees/store');

/* Map DB 'Active' into the key the shared base expects ('IsActive') */
if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
  $model['IsActive'] = (int)$model['Active'];
}

/* Fields rendered by shared/form_base.php */
$fields = [
  ['label'=>'Name',               'name'=>'CommitteeName',       'type'=>'text',     'required'=>true],
  ['label'=>'Description',        'name'=>'Description',         'type'=>'textarea', 'rows'=>3],
  ['label'=>'Meeting Schedule',   'name'=>'MeetingScheduleModel','type'=>'text'],
  ['label'=>'Email',              'name'=>'Email',               'type'=>'email'],
  ['label'=>'Bylaws URL (choose a file to build the Url)',       'name'=>'BylawsUrl', 'type'=>'text', 'url'=>true, 'pattern'=>'https?://.+'],
  ['label'=>'Remarks',            'name'=>'Remarks',             'type'=>'textarea', 'rows'=>3],
];

$showActive = true;
$showSpecial = false;

// Optional header buttons (rendered by shared/form_base.php if present)
$headerButtons = [];

if (!empty($model['Id'])) {
  // Parent must match your Attachments constraint list exactly (e.g., 'Resources')
  $headerButtons[] =
    '<a class="btn btn-secondary" href="' .
    App\Helpers\url('/attachments?parent=BoardsAndCommittees&id=' . urlencode((string)$model['Id']) . '&ptitle=' . urlencode((string)$model['CommitteeName'])) .
    '">Manage attachments</a>';
}

require __DIR__ . '/../shared/form_base.php';
