<?php
// Guard: ensure $model/$errors exist
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($errors) || !is_array($errors)) { $errors = []; }

// Map Active -> IsActive for the checkbox if not present
if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
  $model['IsActive'] = (int)$model['Active'];
}

// Defaults
$defaults = [
  'Id'=>0,
  'BoardId'=>null,
  'OfficerPositionId'=>null,
  'PersonName'=>'',
  'Address1'=>'','Address2'=>'','Town'=>'','State'=>'','Zip'=>'',
  'Phone1'=>'','Phone2'=>'','Email'=>'',
  'InitialApptDate'=>null,'ReappointmentDate'=>null,'ExpiryDate'=>null,
  'Remarks'=>'',
  'IsActive'=>1,
];
$model = $model + $defaults;

$entitySingular = 'Board/Committee';
$isEdit         = ((int)$model['Id'] > 0);
$pageTitle = sprintf(
    '%s Member (Board = %s)',
    !empty($model['Id']) ? 'Edit' : 'New',
    $model['CommitteeName'] ?? 'Unknown, set it below in the Board name field'
);
$baseUrl        = $baseUrl   ?? App\Helpers\url('/boardsandcommitteemembers');
$formAction     = $formAction?? App\Helpers\url($isEdit ? '/boardsandcommitteemembers/update' : '/boardsandcommitteemembers/store');

//get all possible board names for dropdown in edit mode
use App\Models\DB;

$pdo = DB::pdo();
$stmt = $pdo->query("SELECT DISTINCT CommitteeName FROM BoardsAndCommittees WHERE CommitteeName IS NOT NULL AND CommitteeName <> '' ORDER BY CommitteeName");
$dropdownOptions = $stmt->fetchAll(\PDO::FETCH_COLUMN);

// Fields for shared/form_base.php
$fields = [
  [
      'label' => 'Board Name',
      'name'  => 'CommitteeName',
      'type'  => 'datalist',   // tell renderer this field uses a datalist
      'list'  => 'dropdownOptions',  // ID of the <datalist>
      'required'=>true,
      'help'  => 'Start typing and select an existing Board or Committee, or keep typing to create a new one'
  ],
  ['label'=>'Officer Position',  'name'=>'OfficerPositionId','type'=>'number'],
  ['label'=>'Name',              'name'=>'PersonName',       'type'=>'text',    'required'=>true],
  ['label'=>'Address 1',         'name'=>'Address1',         'type'=>'text'],
  ['label'=>'Address 2',         'name'=>'Address2',         'type'=>'text'],
  ['label'=>'Town',              'name'=>'Town',             'type'=>'text'],
  ['label'=>'State',             'name'=>'State',            'type'=>'text'],
  ['label'=>'Zip',               'name'=>'Zip',              'type'=>'text'],
  ['label'=>'Phone 1',           'name'=>'Phone1',           'type'=>'text', 'phone'=>true],
  ['label'=>'Phone 2',           'name'=>'Phone2',           'type'=>'text', 'phone'=>true],
  ['label'=>'Email',             'name'=>'Email',            'type'=>'email'],
  ['label'=>'Initial Appt Date', 'name'=>'InitialApptDate',  'type'=>'date'],
  ['label'=>'Reappointment',     'name'=>'ReappointmentDate','type'=>'date'],
  ['label'=>'Expiry Date',       'name'=>'ExpiryDate',       'type'=>'date'],
  ['label'=>'Remarks',           'name'=>'Remarks',          'type'=>'textarea','rows'=>3],
];
$showActive = true;
$showSpecial = false;

require __DIR__ . '/../shared/form_base.php';
