<?php
// $rows    : result set from controller
// $boards  : dropdown options
// $page_title : title string

$pboardid = isset($_GET['board'])
    ? (int)$_GET['board']
    : ($_SESSION['board_context']['pboardid'] ?? 0);

$pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
$ptitle = $_SESSION['board_context']['ptitle'] ?? '';

$baseUrl        = App\Helpers\url('/boardmeetings');

$pageTitle = 'Meeting Minutes' . ($ptitle ? ' (' . htmlspecialchars($ptitle) . ')' : '');
$entityPlural   = 'Meeting Minutes';
$entitySingular = 'Meeting Minutes';

$listColumns = [
  ['label'=>'Name',                 'field'=>'BoardName', 'link'=>true],
  ['label'=>'Meeting Date',           'field'=>'Date'],
  ['label'=>'Agenda URL',           'field'=>'AgendaUrl', 'type' => 'Url'],
  ['label'=>'Approved Minutes Url', 'field'=>'ApprovedMinutesUrl', 'type' => 'Url'],
  ['label'=>'Recording Url', 'field'=>'RecordingUrl', 'type' => 'Url'],
];

$cfg = [
    'title'       => $page_title,
    'create_url'  => '/boardmeetings/create',
    'edit_url'    => '/boardmeetings/edit',   // expects ?id={Id}
    'delete_url'  => '/boardmeetings/delete', // POST with Id
    'link_field'  => 'PrettyDate',            // clickable link text

    'columns'     => [
        ['header' => 'Board',         'field' => 'BoardName'],
        ['header' => 'Date of Meeting','field' => 'PrettyDate'],
        ['header' => 'Agenda',        'field' => 'AgendaUrl',          'type' => 'url'],
        ['header' => 'Approved Minutes','field' => 'ApprovedMinutesUrl','type' => 'url'],
        ['header' => 'Recording',     'field' => 'RecordingUrl',       'type' => 'url'],
    ],

    'rows'        => array_map(function ($r) {
        // CHANGED ONLY IF DATE FIELD IS MeetingDate IN YOUR SCHEMA
        $dateField = $r['Date'] ?? $r['MeetingDate'] ?? null;
        if ($dateField) {
            $r['PrettyDate'] = date('F j, Y', strtotime($dateField));
        }
        return $r;
    }, $rows),

    // ADDED: Auto-submit committee dropdown filter
    'filters_html' => (function() use ($boards) {
        $sel = isset($_GET['board'])
            ? (int)$_GET['board']
            : ($_SESSION['board_context']['pboardid'] ?? 0);

        ob_start(); ?>
        <form method="get" action="./boardmeetings" class="mb-3 d-flex gap-2 align-items-center">

            <label for="f_board" class="mb-0">Board or Committee:</label>

            <select id="f_board" name="board" class="form-select" style="max-width:380px"
                onchange="this.form.submit()">   <!-- ADDED auto-submit -->
                <!--option value="">(All Committees)</option-->

                <?php foreach ($boards as $b): ?>
                    <option value="<?= (int)$b['Id'] ?>"
                        <?= $sel === (int)$b['Id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($b['CommitteeName'] ?? $b['BoardName']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

        </form>
        <?php return ob_get_clean();
    })(),
];

$showActive = false;
$showSpecial = false;

require __DIR__ . '/../shared/list_base.php';
