<?php
// ---- add this guard at the very top ----
if (!isset($model) && isset($resource) && is_array($resource)) { $model = $resource; }
if (!isset($model) || !is_array($model)) { $model = []; }
$isEdit = !empty($model['Id']);
// ----------------------------------------

$entitySingular = 'Announcement';
$pageTitle      = !empty($model['Id']) ? 'Edit Announcement' : 'New Announcement';
$baseUrl        = App\Helpers\url('/announcements');
$formAction     = App\Helpers\url(!empty($model['Id']) ? '/announcements/update' : '/announcements/store');

$fields = [
  ['label'=>'Title', 'name'=>'Title', 'type'=>'text', 'required'=>true],
  ['label'=>'Body',  'name'=>'Body',  'type'=>'textarea', 'rows'=>6],
  ['label'=>'Start Date', 'name'=>'StartDate', 'type'=>'date'],
  ['label'=>'End Date',   'name'=>'EndDate',   'type'=>'date'],
];

$showActive = true;
$showSpecial = false;

// Optional header buttons (rendered by shared/form_base.php if present)
$headerButtons = [];

if (!empty($model['Id'])) {
  // Parent must match your Attachments constraint list exactly (e.g., 'Resources')
  $headerButtons[] =
    '<a class="btn btn-secondary" href="' .
    App\Helpers\url('/attachments?parent=Announcements&id=' . urlencode((string)$model['Id']) . '&ptitle=' . urlencode((string)$model['Title'])) .
    '">Manage attachments</a>';
}

require __DIR__ . '/../shared/form_base.php';
