<?php
namespace App\Models;

use PDO;
use PDOException;

class DB {
    private static ?PDO $pdo = null;

    public static function pdo(): PDO {
        if (self::$pdo) return self::$pdo;
        $c = $GLOBALS['CONFIG']['db'];
        try {
            if ($c['driver'] === 'sqlsrv') {
                $dsn = "sqlsrv:Server={$c['host']};Database={$c['database']}";
                self::$pdo = new PDO($dsn, $c['username'], $c['password'], [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                ]);
                // SQL Server uses NVARCHAR by default; nothing special here.
            } elseif ($c['driver'] === 'mysql') {
                $charset = $c['charset'] ?? 'utf8mb4';
                $dsn = "mysql:host={$c['host']};dbname={$c['database']};charset={$charset}";
                self::$pdo = new PDO($dsn, $c['username'], $c['password'], [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                ]);
            // ODBC
            } elseif ($c['driver'] === 'odbc') {
                $dsn = "odbc:Driver={ODBC Driver 18 for SQL Server};Server={$c['host']};Database={$c['database']};Encrypt=yes;TrustServerCertificate=yes;";
                self::$pdo = new \PDO($dsn, $c['username'], $c['password'], [
                    \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
                    \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
                ]);
            } else {
                throw new PDOException("Unsupported DB driver: {$c['driver']}");
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo "Database connection failed: " . htmlspecialchars($e->getMessage());
            exit;
        }
        return self::$pdo;
    }
}
