<?php
namespace App\Helpers;

function url(string $path = ''): string
{
    // Base = DIR of the script + '/index.php'  (e.g., /TownOfCushingME/public/index.php)
    $script = $_SERVER['SCRIPT_NAME'] ?? '/index.php';
    $dir    = rtrim(str_replace('\\', '/', dirname($script)), '/');
    $base   = $dir . '/index.php';

    // Normalize requested path
    $path = '/' . ltrim($path, '/');

    // SAFETY: if caller passed '/index.php/...' strip it so we don't get '/index.php/index.php/...'
    if (str_starts_with($path, '/index.php')) {
        $path = substr($path, strlen('/index.php')); // results in '' or '/...'
        if ($path === false) $path = '';
    }

    // If asking for the "root", return base as-is
    if ($path === '/' || $path === '') {
        return $base;
    }

    return $base . $path;
}

function redirect(string $path): void {
    header('Location: ' . url($path));
    exit;
}
