<?php
namespace App\Helpers;

function log_dir(): string {
    $dir = __DIR__ . '/../../storage/logs';
    if (!is_dir($dir)) @mkdir($dir, 0777, true);
    return $dir;
}
function log_path(): string {
    return log_dir() . '/app.log';
}
function log_error($e): void {
    $ts = date('Y-m-d H:i:s');
    $uri = $_SERVER['REQUEST_METHOD'] . ' ' . ($_SERVER['REQUEST_URI'] ?? '');
    $msg = is_string($e) ? $e : (get_class($e) . ': ' . ($e->getMessage() ?? ''));
    $trace = is_string($e) ? '' : ($e->getTraceAsString());
    $entry = "[$ts] $uri\n$msg\n$trace\n\n";
    $file = log_path();
    @file_put_contents($file, $entry, FILE_APPEND);
}
function log_info(string $message): void {
    $ts = date('Y-m-d H:i:s');
    $uri = $_SERVER['REQUEST_METHOD'] . ' ' . ($_SERVER['REQUEST_URI'] ?? '');
    $entry = "[$ts] $uri\nINFO: $message\n\n";
    $file = log_path();
    @file_put_contents($file, $entry, FILE_APPEND);
}
