<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class TownStaffPositionsController {

    public static function index(): string {
        $pdo = DB::pdo();

        $sql = "SELECT Id, JobTitle, PersonName, Phone1, Email, IsAdmin as IsAdmin, Active as IsActive
                FROM TownStaffPositions
                ORDER BY JobTitle";

        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'TownStaffPositions';
        include __DIR__ . '/../Views/townstaffpositions/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
$model = [
  'Id' => 0,
  'JobTitle' => '',
  'PersonName' => '',
  'Address1' => '',
  'Address2' => '',
  'Town' => '',
  'State' => '',
  'Zip' => '',
  'Phone1' => '',
  'Phone2' => '',
  'Email' => '',
  'Remarks' => '',
  'IsAdmin' => 0,
  'PasswordHash' => '',
  'IsActive' => 1
];
$errors = [];
//include __DIR__ . '/../Views/townstaffpositions/form.php';
        ob_start();
        $title = 'New TownStaffPositions';
        include __DIR__ . '/../Views/townstaffpositions/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $data = [
            'JobTitle' => trim((string)($_POST['JobTitle'] ?? '')),
            'PersonName' => trim((string)($_POST['PersonName'] ?? '')),
            'Address1' => trim((string)($_POST['Address1'] ?? '')),
            'Address2' => trim((string)($_POST['Address2'] ?? '')),
            'Town' => trim((string)($_POST['Town'] ?? '')),
            'State' => trim((string)($_POST['State'] ?? '')),
            'Zip' => trim((string)($_POST['Zip'] ?? '')),
            'Phone1' => trim((string)($_POST['Phone1'] ?? '')),
            'Phone2' => trim((string)($_POST['Phone2'] ?? '')),
            'Email' => trim((string)($_POST['Email'] ?? '')),
            'Remarks' => trim((string)($_POST['Remarks'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0),
            'IsAdmin' => (isset($_POST['Admin']) ? 1 : 0),
            'PasswordHash' => trim((string)($_POST['AdminPassword'] ?? '')),
            'CreatedBy' => $createdBy
        ];

        $admin = isset($_POST['IsAdmin']) ? 1 : 0;
        $active = isset($_POST['IsActive']) ? 1 : 0;

        $passwordHash = '';
        if (!empty($_POST['AdminPassword'])) {
          $passwordHash = password_hash(trim((string)($_POST['AdminPassword'] ?? '')), PASSWORD_DEFAULT);
        }

        $sql = "INSERT INTO TownStaffPositions (JobTitle, PersonName, Address1, Address2, Town, State, Zip, Phone1, Phone2, Email, Remarks, IsAdmin, PasswordHash, Active, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([trim((string)($_POST['JobTitle'] ?? '')), trim((string)($_POST['PersonName'] ?? '')), trim((string)($_POST['Address1'] ?? '')), trim((string)($_POST['Address2'] ?? '')), trim((string)($_POST['Town'] ?? '')), trim((string)($_POST['State'] ?? '')), trim((string)($_POST['Zip'] ?? '')), trim((string)($_POST['Phone1'] ?? '')), trim((string)($_POST['Phone2'] ?? '')), trim((string)($_POST['Email'] ?? '')), trim((string)($_POST['Remarks'] ?? '')), $admin, $passwordHash, $active, $createdBy]);

        $id = (int)$pdo->lastInsertId();
        audit('TownStaffPositions','create',$id,$data);
        redirect('/townstaffpositions');
    }

public static function edit(): string
{
    $id  = (int)($_GET['id'] ?? 0);
    $pdo = \App\Models\DB::pdo();

    $stmt = $pdo->prepare("SELECT * FROM TownStaffPositions WHERE Id=?");
    $stmt->execute([$id]);
    $model = $stmt->fetch();

    if (!$model) {
        http_response_code(404);
        return "Not found";
    }

    // Normalize Admin → IsAdmin and Active → IsActive for shared form
    if (!array_key_exists('IsAdmin', $model) && array_key_exists('Admin', $model)) {
        $model['IsAdmin'] = (int)$model['Admin'];
    }
    if (!array_key_exists('IsActive', $model) && array_key_exists('Active', $model)) {
        $model['IsActive'] = (int)$model['Active'];
    }

    $errors = [];

    ob_start();
    include __DIR__ . '/../Views/townstaffpositions/form.php';
    return ob_get_clean();
}

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM TownStaffPositions WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'JobTitle' => trim((string)($_POST['JobTitle'] ?? '')),
            'PersonName' => trim((string)($_POST['PersonName'] ?? '')),
            'Address1' => trim((string)($_POST['Address1'] ?? '')),
            'Address2' => trim((string)($_POST['Address2'] ?? '')),
            'Town' => trim((string)($_POST['Town'] ?? '')),
            'State' => trim((string)($_POST['State'] ?? '')),
            'Zip' => trim((string)($_POST['Zip'] ?? '')),
            'Phone1' => trim((string)($_POST['Phone1'] ?? '')),
            'Phone2' => trim((string)($_POST['Phone2'] ?? '')),
            'Email' => trim((string)($_POST['Email'] ?? '')),
            'Remarks' => trim((string)($_POST['Remarks'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0),
            'IsAdmin' => (isset($_POST['Admin']) ? 1 : 0),
            'PasswordHash' => trim((string)($_POST['AdminPassword'] ?? ''))
        ];
        $sql = "UPDATE TownStaffPositions SET JobTitle=?, PersonName=?, Address1=?, Address2=?, Town=?, State=?, Zip=?, Phone1=?, Phone2=?, Email=?, Remarks=?, IsAdmin=?, PasswordHash=?, Active=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
$admin = isset($_POST['IsAdmin']) ? 1 : 0;

$passwordHash = '';
        \App\Helpers\log_info("staff.store before pw: {$passwordHash}");
        \App\Helpers\log_info("staff.store before pw: {$data['PasswordHash']}");
if (!empty($_POST['AdminPassword'])) {
  $passwordHash = password_hash(trim((string)($_POST['AdminPassword'] ?? '')), PASSWORD_DEFAULT);
        \App\Helpers\log_info("staff.store in pw: {$passwordHash}");
}

$active = isset($_POST['IsActive']) ? 1 : 0;
$id = (int)($_POST['Id'] ?? 0);
        $stmt->execute([trim((string)($_POST['JobTitle'] ?? '')), trim((string)($_POST['PersonName'] ?? '')), trim((string)($_POST['Address1'] ?? '')), trim((string)($_POST['Address2'] ?? '')), trim((string)($_POST['Town'] ?? '')), trim((string)($_POST['State'] ?? '')), trim((string)($_POST['Zip'] ?? '')), trim((string)($_POST['Phone1'] ?? '')), trim((string)($_POST['Phone2'] ?? '')), trim((string)($_POST['Email'] ?? '')), trim((string)($_POST['Remarks'] ?? '')), $admin, $passwordHash, $active, $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('TownStaffPositions','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/townstaffpositions');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM TownStaffPositions WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM TownStaffPositions WHERE Id=?");
        $stmt->execute([$id]);
        audit('TownStaffPositions','delete',$id,['before'=>$row]);
        redirect('/townstaffpositions');
    }
}
