<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

class ResourcesController {
    public static function index(): string {
        $pdo = DB::pdo();
        $rows = $pdo->query("SELECT Id, Title, Url, Category, SortOrder, Active FROM resources ORDER BY SortOrder, Title")->fetchAll();
        ob_start();
        $title = 'Resources';
        include __DIR__ . '/../Views/resources/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $model = [
            'Id' => 0,
            'Title' => '',
            'Url' => '',
            'Category' => '',
            'SortOrder' => 0,
            'Description' => '',
            'IsActive' => 1,
        ];
        $errors = [];
        ob_start();
        $title = 'New Resource';
        include __DIR__ . '/../Views/resources/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();

        $data = [
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Url' => trim((string)($_POST['Url'] ?? '')),
            'Category' => trim((string)($_POST['Category'] ?? '')),
            'SortOrder' => is_numeric($_POST['SortOrder'] ?? null) ? (int)$_POST['SortOrder'] : 0,
            'Description' => trim((string)($_POST['Description'] ?? '')),
            'Active' => isset($_POST['IsActive']) ? 1 : 0,
            'CreatedBy' => $createdBy
        ];

        //Save file/url
        $parentTable = 'Resources';
        $upload = \App\Helpers\handleupload('attachment_Url', $parentTable);
        if ($upload) {
            // Build full URL using config PrependURL
            $data['Url'] = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }

        $sql = "INSERT INTO resources (Title, Url, Category, SortOrder, Description, Active, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Title'], $data['Url'], $data['Category'], $data['SortOrder'], $data['Description'], $data['Active'], $createdBy
        ]);

        $id = (int)$pdo->lastInsertId();
        audit('Resources', 'create', $id, $data);
        redirect('/resources');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM resources WHERE Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();

        if (!$model) {
            http_response_code(404);
            return "Not found";
        }

        if (array_key_exists('Active', $model) && !array_key_exists('IsActive', $model)) {
            $model['IsActive'] = (int)$model['Active'];
        }

        $errors = [];
        ob_start();
        $title = 'Edit Resource';
        include __DIR__ . '/../Views/resources/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $id = (int)($_POST['Id'] ?? 0);

        $data = [
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Url' => trim((string)($_POST['Url'] ?? '')),
            'Category' => trim((string)($_POST['Category'] ?? '')),
            'SortOrder' => is_numeric($_POST['SortOrder'] ?? null) ? (int)$_POST['SortOrder'] : 0,
            'Description' => trim((string)($_POST['Description'] ?? '')),
            'Active' => isset($_POST['IsActive']) ? 1 : 0,
        ];

        //Save file/url
        $parentTable = 'Resources';
        $upload = \App\Helpers\handleupload('attachment_Url', $parentTable);
        if ($upload) {
            // Build full URL using config PrependURL
            $data['Url'] = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }

        $sql = "UPDATE resources SET Title=?, Url=?, Category=?, SortOrder=?, Description=?, Active=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $data['Title'], $data['Url'], $data['Category'], $data['SortOrder'], $data['Description'], $data['Active'], $id
        ]);

        audit('Resources', 'update', $id, $data);
        redirect('/resources');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM Resources WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM Resources WHERE Id=?");
        $stmt->execute([$id]);
        audit('Resources','delete',$id,['before'=>$row]);
        redirect('/resources');
    }
}

