<?php
namespace App\Controllers;

use App\Models\DB;

class HomeController {
    public static function index(): string {
        $pdo = DB::pdo();
        // Town (first active row)
        $driver = $pdo->getAttribute(\PDO::ATTR_DRIVER_NAME);
        if ($driver === 'mysql') {
            $stmt = $pdo->query("SELECT * FROM Town WHERE Active = 1 ORDER BY Id LIMIT 1");
            $town = $stmt->fetch();
        } else {
            $town = $pdo->query("SELECT TOP 1 * FROM Town WHERE Active = 1 ORDER BY Id")->fetch();
        }
        if ($town === false) {
            // MySQL compatibility
            $stmt = $pdo->query("SELECT * FROM Town WHERE Active = 1 ORDER BY Id LIMIT 1");
            $town = $stmt->fetch();
        }

        // Today hours (Mon=1..Sun=7) - compute in PHP to avoid engine-specific weekday
        $dow = (int)date('N'); // 1=Mon .. 7=Sun
        $stmt = $pdo->prepare("SELECT * FROM Hours WHERE Active=1 AND TownId = :tid AND DayOfWeek = :dow ORDER BY DeptName");
        $stmt->execute([':tid'=>$town['Id'] ?? 1, ':dow'=>$dow]);
        $hours = $stmt->fetchAll();

        // Render
        ob_start();
        $title = 'Home';
        include __DIR__ . '/../Views/home.php';
        return ob_get_clean();
    }
}
