<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

class BoardsAndCommitteesController {
    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT Id, CommitteeName, Email, PageSlug, BylawsUrl, Active AS IsActive
                FROM BoardsAndCommittees
                ORDER BY CommitteeName";
        $rows = $pdo->query($sql)->fetchAll();

        ob_start();
        $title = 'Boards & Committees';
        include __DIR__ . '/../Views/boardsandcommittees/list.php';
        return ob_get_clean();
    }

    public static function create(): string {

$model = [
    'Id' => 0,
    'CommitteeName' => '',
    'Description' => '',
    'MeetingScheduleModel' => '',
    'Email' => '',
    'PageSlug' => '',
    'BylawsUrl' => '',
    'Remarks' => '',
    'IsActive' => 1, // shared form expects this name
];
$errors = [];
// keep your existing include:
//include __DIR__ . '/../Views/boardsandcommittees/form.php';

        $board = [
            'Id' => null,
            'CommitteeName' => '',
            'Description' => '',
            'MeetingScheduleModel' => '',
            'Email' => '',
            'PageSlug' => '',
            'BylawsUrl' => '',
            'Remarks' => '',
            'Active' => 1,
        ];
        ob_start();
        $title = 'Create Board/Committee';
        include __DIR__ . '/../Views/boardsandcommittees/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $name  = trim($_POST['CommitteeName'] ?? '');
        $email = trim($_POST['Email'] ?? '');
        $BylawsUrl = '';
        if ($name === '') {
            $_SESSION['flash'] = 'Committee Name is required.';
            redirect('/boardsandcommittees/create');
        }
        if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $_SESSION['flash'] = 'Board email is not a valid email address.';
            redirect('/boardsandcommittees/create');
        }

        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $active = isset($_POST['IsActive']) ? 1 : 0;

        //Save file/url
        $parentTable = 'BoardsAndCommittees';
        $upload = \App\Helpers\handleupload('attachment_BylawsUrl', $parentTable);
        if ($upload) {
            // Build full URL using config PrependURL
            $BylawsUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }

        $sql = "INSERT INTO BoardsAndCommittees
                (CommitteeName, Description, MeetingScheduleModel, Email, PageSlug, BylawsUrl, Remarks, Active, CreatedAt, CreatedBy)
                VALUES (?,?,?,?,?,?,?,?, NOW(0), ?)";

        \App\Helpers\log_info("BoardsAndCommittees.store SQL: {$sql}");
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $name,
            ($_POST['Description'] ?? null),
            ($_POST['MeetingScheduleModel'] ?? null),
            ($email !== '' ? $email : null),
            ($_POST['PageSlug'] ?? null),
            $BylawsUrl,
            ($_POST['Remarks'] ?? null),
            $active,
            $createdBy
        ]);

        $id = (int)$pdo->lastInsertId();
        audit('BoardsAndCommittees','create',$id,[
            $name,
            ($_POST['Description'] ?? null),
            ($_POST['MeetingScheduleModel'] ?? null),
            ($email !== '' ? $email : null),
            ($_POST['PageSlug'] ?? null),
            $BylawsUrl,
            ($_POST['Remarks'] ?? null),
            $active,
            $createdBy
        ]);
        redirect('/boardsandcommittees');
    }

    public static function edit(): string {
        $id  = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();

        $stmt = $pdo->prepare("SELECT b.* FROM BoardsAndCommittees b WHERE b.Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();

        if (!$model) {
            http_response_code(404);
            return "Not found";
        }

        // normalize for shared form checkbox
        $model['IsActive'] = (int)$model['Active'];
        $errors = [];

        ob_start();
        include __DIR__ . '/../Views/boardsandcommittees/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id    = (int)($_POST['Id'] ?? 0);
        $name  = trim($_POST['CommitteeName'] ?? '');
        $email = trim($_POST['Email'] ?? '');
        $BylawsUrl = '';

        if ($id <= 0) {
            http_response_code(400);
            echo "Invalid Id";
            return;
        }
        if ($name === '') {
            $_SESSION['flash'] = 'Committee Name is required.';
            redirect('/boardsandcommittees/edit?id=' . $id);
        }
        if ($email !== '' && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $_SESSION['flash'] = 'Board email is not a valid email address.';
            redirect('/boardsandcommittees/edit?id=' . $id);
        }

        $active = isset($_POST['IsActive']) ? 1 : 0;
        $id = (int)($_POST['Id'] ?? 0);

        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM BoardsAndCommittees WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        //Save file/url
        $parentTable = 'BoardsAndCommittees';
        $upload = \App\Helpers\handleupload('attachment_BylawsUrl', $parentTable);
        \App\Helpers\log_info("before: {$BylawsUrl}");
        if ($upload) {
            // Build full URL using config PrependURL
            $BylawsUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
        }
        \App\Helpers\log_info("after: {$BylawsUrl}");

        $sql = "UPDATE BoardsAndCommittees SET
          CommitteeName=?, Description=?, MeetingScheduleModel=?, Email=?,
          PageSlug=?, BylawsUrl=?, Remarks=?, Active=?
          WHERE Id=?";

        \App\Helpers\log_info("BoardsAndCommittees.update SQL: {$sql}");

        $pdo->prepare($sql)->execute([
            trim($_POST['CommitteeName'] ?? ''),
            trim($_POST['Description'] ?? ''),
            trim($_POST['MeetingScheduleModel'] ?? ''),
            trim($_POST['Email'] ?? ''),
            trim($_POST['PageSlug'] ?? ''),
            trim($BylawsUrl),
            trim($_POST['Remarks'] ?? ''),
            $active,
            $id
        ]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('BoardsAndCommittees','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/boardsandcommittees');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        if ($id <= 0) {
            http_response_code(400);
            echo "Invalid Id";
            return;
        }
        $pdo = DB::pdo();

        $sel = $pdo->prepare("SELECT * FROM BoardsAndCommittees WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];

        $stmt = $pdo->prepare("DELETE FROM BoardsAndCommittees WHERE Id=?");
        $stmt->execute([$id]);

        audit('BoardsAndCommittees','delete',$id,['before'=>$row]);
        redirect('/boardsandcommittees');
    }
}
