<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class BoardsAndCommitteeMembersController {

    public static function index(): string {
        $pdo = DB::pdo();

        $sql = "SELECT m.Id, m.BoardId, m.OfficerPositionId, m.PersonName,
          m.Town, m.State, m.Phone1, m.Email,
          m.Active AS IsActive,
          b.CommitteeName
        FROM BoardsAndCommitteeMembers m
        LEFT JOIN BoardsAndCommittees b ON b.Id = m.BoardId
        ORDER BY m.PersonName";

        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'BoardsAndCommitteeMembers';
        include __DIR__ . '/../Views/boardsandcommitteemembers/list.php';
        return ob_get_clean();
    }

    public static function create(): string {

//$model = [];
$errors = [];
// keep your existing include:
//include __DIR__ . '/../Views/boardsandcommitteemembers/form.php';

        $resource = [];
        ob_start();
        $title = 'New BoardsAndCommitteeMembers';
        include __DIR__ . '/../Views/boardsandcommitteemembers/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $committeeName = ($_POST['CommitteeName'] ?? '');
        $sql = "Select Id from BoardsAndCommittees where CommitteeName=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$committeeName]);
        $boardId = (int)$stmt->fetchColumn();
        \App\Helpers\log_info('BoardMembers id1:' . $boardId);

        //for the Python crud tester
        if ($boardId == 0) {
            $boardId  = (int)($_POST['BoardId'] ?? 0);
        }
        \App\Helpers\log_info('BoardMembers id2:' . $boardId);

        $data = [
            'BoardId' => $boardId,
            'OfficerPositionId' => (int)($_POST['OfficerPositionId'] ?? 0),
            'PersonName' => trim((string)($_POST['PersonName'] ?? '')),
            'Address1' => trim((string)($_POST['Address1'] ?? '')),
            'Address2' => trim((string)($_POST['Address2'] ?? '')),
            'Town' => trim((string)($_POST['Town'] ?? '')),
            'State' => trim((string)($_POST['State'] ?? '')),
            'Zip' => trim((string)($_POST['Zip'] ?? '')),
            'Phone1' => trim((string)($_POST['Phone1'] ?? '')),
            'Phone2' => trim((string)($_POST['Phone2'] ?? '')),
            'Email' => trim((string)($_POST['Email'] ?? '')),
            'InitialApptDate' => ($_POST['InitialApptDate'] !== '' ? $_POST['InitialApptDate'] : null),
            'ReappointmentDate' => ($_POST['ReappointmentDate'] !== '' ? $_POST['ReappointmentDate'] : null),
            'ExpiryDate' => ($_POST['ExpiryDate'] !== '' ? $_POST['ExpiryDate'] : null),
            'Remarks' => trim((string)($_POST['Remarks'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0),
            'CreatedBy' => $createdBy
        ];

        $active = isset($_POST['IsActive']) ? 1 : 0;

        $sql = "INSERT INTO BoardsAndCommitteeMembers (BoardId, OfficerPositionId, PersonName, Address1, Address2, Town, State, Zip, Phone1, Phone2, Email, InitialApptDate, ReappointmentDate, ExpiryDate, Remarks, Active, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);

$pdo->prepare($sql)->execute([
  $boardId,
  $_POST['OfficerPositionId'] !== '' ? (int)$_POST['OfficerPositionId'] : null,
  trim($_POST['PersonName'] ?? ''),
  trim($_POST['Address1'] ?? ''),
  trim($_POST['Address2'] ?? ''),
  trim($_POST['Town'] ?? ''),
  trim($_POST['State'] ?? ''),
  trim($_POST['Zip'] ?? ''),
  trim($_POST['Phone1'] ?? ''),
  trim($_POST['Phone2'] ?? ''),
  trim($_POST['Email'] ?? ''),
  $_POST['InitialApptDate'] ?: null,
  $_POST['ReappointmentDate'] ?: null,
  $_POST['ExpiryDate'] ?: null,
  trim($_POST['Remarks'] ?? ''),
  $active,
  $createdBy
]);

        #$stmt->execute([$boardId, (int)($_POST['OfficerPositionId'] ?? 0), trim((string)($_POST['PersonName'] ?? '')), trim((string)($_POST['Address1'] ?? '')), trim((string)($_POST['Address2'] ?? '')), trim((string)($_POST['Town'] ?? '')), trim((string)($_POST['State'] ?? '')), trim((string)($_POST['Zip'] ?? '')), trim((string)($_POST['Phone1'] ?? '')), trim((string)($_POST['Phone2'] ?? '')), trim((string)($_POST['Email'] ?? '')), ($_POST['InitialApptDate'] !== '' ? $_POST['InitialApptDate'] : null), ($_POST['ReappointmentDate'] !== '' ? $_POST['ReappointmentDate'] : null), ($_POST['ExpiryDate'] !== '' ? $_POST['ExpiryDate'] : null), trim((string)($_POST['Remarks'] ?? '')), (isset($_POST['Active']) ? 1 : 0), @createdBy]);

        $id = (int)$pdo->lastInsertId();
        audit('BoardsAndCommitteeMembers','create',$id,$data);
        redirect('/boardsandcommitteemembers');
    }

public static function edit(): string
{
    $id  = (int)($_GET['id'] ?? 0);
    $pdo = \App\Models\DB::pdo();

    $stmt = $pdo->prepare("SELECT m.*, b.CommitteeName FROM BoardsAndCommitteeMembers m LEFT JOIN BoardsAndCommittees b ON b.Id = m.BoardId WHERE m.Id=?");
    $stmt->execute([$id]);
    $model = $stmt->fetch();

    if (!$model) {
        http_response_code(404);
        return "Not found";
    }

    // Normalize for shared form checkbox
    if (!array_key_exists('IsActive', $model) && array_key_exists('Active', $model)) {
        $model['IsActive'] = (int)$model['Active'];
    }

    // Ensure $errors exists for the view
    $errors = [];

    ob_start();
    include __DIR__ . '/../Views/boardsandcommitteemembers/form.php';
    return ob_get_clean();
}

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardsAndCommitteeMembers WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'BoardId' => (int)($_POST['BoardId'] ?? 0),
            'OfficerPositionId' => (int)($_POST['OfficerPositionId'] ?? 0),
            'PersonName' => trim((string)($_POST['PersonName'] ?? '')),
            'Address1' => trim((string)($_POST['Address1'] ?? '')),
            'Address2' => trim((string)($_POST['Address2'] ?? '')),
            'Town' => trim((string)($_POST['Town'] ?? '')),
            'State' => trim((string)($_POST['State'] ?? '')),
            'Zip' => trim((string)($_POST['Zip'] ?? '')),
            'Phone1' => trim((string)($_POST['Phone1'] ?? '')),
            'Phone2' => trim((string)($_POST['Phone2'] ?? '')),
            'Email' => trim((string)($_POST['Email'] ?? '')),
            'InitialApptDate' => ($_POST['InitialApptDate'] !== '' ? $_POST['InitialApptDate'] : null),
            'ReappointmentDate' => ($_POST['ReappointmentDate'] !== '' ? $_POST['ReappointmentDate'] : null),
            'ExpiryDate' => ($_POST['ExpiryDate'] !== '' ? $_POST['ExpiryDate'] : null),
            'Remarks' => trim((string)($_POST['Remarks'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0)
        ];

$active = isset($_POST['IsActive']) ? 1 : 0;
$id = (int)($_POST['Id'] ?? 0);

        $sql = "UPDATE BoardsAndCommitteeMembers SET BoardId=?, OfficerPositionId=?, PersonName=?, Address1=?, Address2=?, Town=?, State=?, Zip=?, Phone1=?, Phone2=?, Email=?, InitialApptDate=?, ReappointmentDate=?, ExpiryDate=?, Remarks=?, Active=? WHERE Id=?";

$pdo->prepare($sql)->execute([
  (int)($_POST['BoardId'] ?? 0),
  $_POST['OfficerPositionId'] !== '' ? (int)$_POST['OfficerPositionId'] : null,
  trim($_POST['PersonName'] ?? ''),
  trim($_POST['Address1'] ?? ''),
  trim($_POST['Address2'] ?? ''),
  trim($_POST['Town'] ?? ''),
  trim($_POST['State'] ?? ''),
  trim($_POST['Zip'] ?? ''),
  trim($_POST['Phone1'] ?? ''),
  trim($_POST['Phone2'] ?? ''),
  trim($_POST['Email'] ?? ''),
  $_POST['InitialApptDate'] ?: null,
  $_POST['ReappointmentDate'] ?: null,
  $_POST['ExpiryDate'] ?: null,
  trim($_POST['Remarks'] ?? ''),
  $active,
  $id
]);

        #$stmt = $pdo->prepare($sql);
        #$stmt->execute([(int)($_POST['BoardId'] ?? 0), (int)($_POST['OfficerPositionId'] ?? 0), trim((string)($_POST['PersonName'] ?? '')), trim((string)($_POST['Address1'] ?? '')), trim((string)($_POST['Address2'] ?? '')), trim((string)($_POST['Town'] ?? '')), trim((string)($_POST['State'] ?? '')), trim((string)($_POST['Zip'] ?? '')), trim((string)($_POST['Phone1'] ?? '')), trim((string)($_POST['Phone2'] ?? '')), trim((string)($_POST['Email'] ?? '')), ($_POST['InitialApptDate'] !== '' ? $_POST['InitialApptDate'] : null), ($_POST['ReappointmentDate'] !== '' ? $_POST['ReappointmentDate'] : null), ($_POST['ExpiryDate'] !== '' ? $_POST['ExpiryDate'] : null), trim((string)($_POST['Remarks'] ?? '')), (isset($_POST['Active']) ? 1 : 0), $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('BoardsAndCommitteeMembers','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/boardsandcommitteemembers');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardsAndCommitteeMembers WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM BoardsAndCommitteeMembers WHERE Id=?");
        $stmt->execute([$id]);
        audit('BoardsAndCommitteeMembers','delete',$id,['before'=>$row]);
        redirect('/boardsandcommitteemembers');
    }
}
