<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class BoardScheduleRulesController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT s.Id, s.BoardId, s.RRule, s.HolidayPolicy, s.Notes, s.Active as IsActive, b.CommitteeName
        FROM BoardScheduleRules s
        LEFT JOIN BoardsAndCommittees b ON b.Id = s.BoardId
        ORDER BY s.BoardId";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'BoardScheduleRules';
        include __DIR__ . '/../Views/boardschedulerules/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $model = [];  
        ob_start();
        $title = 'New BoardScheduleRules';
        include __DIR__ . '/../Views/boardschedulerules/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $committeeName = ($_POST['CommitteeName'] ?? '');
        $sql = "Select Id from BoardsAndCommittees where CommitteeName=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$committeeName]);
        $boardId = (int)$stmt->fetchColumn();
        \App\Helpers\log_info('BoardSchedule id1:' . $boardId);

        //for the Python crud tester
        if ($boardId == 0) {
            $boardId  = (int)($_POST['BoardId'] ?? 0);
        }
        \App\Helpers\log_info('BoardSchedule id2:' . $boardId);

        $data = [
            'BoardId' => $boardId,
            'RRule' => trim((string)($_POST['RRule'] ?? '')),
            'HolidayPolicy' => trim((string)($_POST['HolidayPolicy'] ?? '')),
            'Notes' => trim((string)($_POST['Notes'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0),
            'CreatedBy' => $createdBy
        ];

        $sql = "INSERT INTO BoardScheduleRules (BoardId, RRule, HolidayPolicy, Notes, Active, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$boardId, trim((string)($_POST['RRule'] ?? '')), trim((string)($_POST['HolidayPolicy'] ?? '')), trim((string)($_POST['Notes'] ?? '')), (isset($_POST['Active']) ? 1 : 0), $createdBy]);

        $id = (int)$pdo->lastInsertId();
        audit('BoardScheduleRules','create',$id,$data);
        redirect('/boardschedulerules');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT s.*, b.CommitteeName FROM BoardScheduleRules s LEFT JOIN BoardsAndCommittees b ON b.Id = s.BoardId WHERE s.Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();
        if (!$model) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/boardschedulerules/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardScheduleRules WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'BoardId' => (int)($_POST['BoardId'] ?? 0),
            'RRule' => trim((string)($_POST['RRule'] ?? '')),
            'HolidayPolicy' => trim((string)($_POST['HolidayPolicy'] ?? '')),
            'Notes' => trim((string)($_POST['Notes'] ?? '')),
            'Active' => (isset($_POST['Active']) ? 1 : 0)
        ];
        $sql = "UPDATE BoardScheduleRules SET BoardId=?, RRule=?, HolidayPolicy=?, Notes=?, Active=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([(int)($_POST['BoardId'] ?? 0), trim((string)($_POST['RRule'] ?? '')), trim((string)($_POST['HolidayPolicy'] ?? '')), trim((string)($_POST['Notes'] ?? '')), (isset($_POST['Active']) ? 1 : 0), $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('BoardScheduleRules','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/boardschedulerules');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardScheduleRules WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM BoardScheduleRules WHERE Id=?");
        $stmt->execute([$id]);
        audit('BoardScheduleRules','delete',$id,['before'=>$row]);
        redirect('/boardschedulerules');
    }
}
