<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;
use function App\Helpers\url;
use function App\Helpers\handleupload;

use Exception;

class BoardMeetingMinutesController
{
    /** GET /boardmeetingminutes */
    public static function index(): void
    {
        $pdo = DB::pdo();

        $pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
        $pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
        $pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
        $ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');
        \App\Helpers\log_info('BoardMinutes index:' . $pboardid);
        \App\Helpers\log_info('BoardMinutes index:' . $pparent);
        \App\Helpers\log_info('BoardMinutes index:' . $pboardmeetingid);
        \App\Helpers\log_info('BoardMinutes index:' . $ptitle);

        // Boards list for filter dropdown
        $boards = $pdo->query("SELECT Id, CommitteeName as BoardName FROM boardsandcommittees ORDER BY CommitteeName")->fetchAll(\PDO::FETCH_ASSOC);

        // Optional board filter (?board=ID)
        //$boardId = isset($_GET['board']) ? (int)$_GET['board'] : null;
        //$committeeName = isset($_GET['board']) ? (int)$_GET['board'] : null;

        $rows = [];
        if ($pboardid) {
            $stmt = $pdo->prepare("
                SELECT m.Id, m.BoardMeetingId, b.CommitteeName AS BoardName, DATE(m.MeetingDate) as Date,
                       m.AgendaUrl, m.ApprovedMinutesUrl, m.RecordingUrl
                FROM boardmeetingminutes m
                JOIN boardsandcommittees b ON b.Id = m.BoardMeetingId
                WHERE m.BoardMeetingId = ?
                ORDER BY m.MeetingDate DESC
            ");
            $stmt->execute([$pboardid]);
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        //} else {
        //    $stmt = $pdo->query("
        //        SELECT m.Id, m.BoardId, b.CommitteeName AS BoardName, DATE(m.MeetingDate) As Date,
        //               m.AgendaUrl, m.ApprovedMinutesUrl, m.RecordingUrl
        //        FROM boardmeetingminutes m
        //        JOIN boardsandcommittees b ON b.Id = m.BoardId
        //        ORDER BY b.CommitteeName ASC, m.MeetingDate DESC
        //    ");
        }

        $page_title = 'Board Meeting Minutes';
        require __DIR__ . '/../Views/boardmeetingminutes/list.php';
    }

    /** GET /boardmeetingminutes/create */
    public static function create(): void
    {
        $pdo = DB::pdo();
        $boards = $pdo->query("SELECT Id, CommitteeName as BoardName FROM boardsandcommittees ORDER BY CommitteeName")->fetchAll(\PDO::FETCH_ASSOC);

        $pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
        $pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
        $pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
        $ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');

        \App\Helpers\log_info('BoardMinutes create:' . $ptitle);

        $record = [
            'pboardid' => $pboardid,
            'pparent' => $pparent,
            'pboardmeetingid' => $pboardmeetingid,
            'ptitle' => $ptitle,
            'Id' => null,
            'BoardMeetingId' => $pboardmeetingid,
            'BoardName' => $ptitle,
            'Date' => '',
            'AgendaUrl' => '',
            'ApprovedMinutesUrl' => '',
            'RecordingUrl' => ''
        ];
        $page_title = 'Add Board Meeting Minutes';
        require __DIR__ . '/../Views/boardmeetingminutes/form.php';
    }

    /** POST /boardmeetingminutes/store */
    public static function store(): void
    {
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();

        $pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
        $pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
        $pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
        $ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');

        $boardId = $pboardid;
        \App\Helpers\log_info('BoardMinutes id:' . $boardId);

        //for the Python crud tester
        if ($boardId == 0) {
            $boardId  = (int)($_POST['BoardId'] ?? 0);
            \App\Helpers\log_info('BoardMinutes id2:' . $boardId);
        }
        $boardMeetingId = 0;
        if ($boardMeetingId == 0) {
            $boardMeetingId  = (int)($_POST['BoardMeetingId'] ?? 0);
        }
        \App\Helpers\log_info('BoardMinutes mid:' . $boardMeetingId);

        //$sql = "Select CommitteeName as BoardName from BoardsAndCommittees where Id=?";
        //$stmt = $pdo->prepare($sql);
        //$stmt->execute([$boardId]);
        $BoardName = $ptitle;

        $MeetingDate = trim((string)($_POST['Date'] ?? '')); // yyyy-mm-dd from <input type="date">
        \App\Helpers\log_info('BoardMinutes date:' . $MeetingDate);
        $AgendaUrl = trim((string)($_POST['AgendaUrl'] ?? ''));
        $ApprovedMinutesUrl = trim((string)($_POST['ApprovedMinutesUrl'] ?? ''));
        $RecordingUrl = trim((string)($_POST['RecordingUrl'] ?? ''));

        if (!$boardId || !$MeetingDate) {
            http_response_code(400);
            echo "Board and Meeting Date are required.";
            return;
        }

        // Normalize date to full datetime (00:00:00)
        //$MeetingDateDT = $MeetingDate . ' 00:00:00';

        //Save file/url
        $parentTable = 'BoardMeetingMinutes';
        foreach (['AgendaUrl', 'ApprovedMinutesUrl', 'RecordingUrl'] as $field) {
            $inputName = 'attachment_' . $field;
            $upload = \App\Helpers\handleUpload($inputName, $parentTable);
            if ($upload) {
                if ($field == 'AgendaUrl') {
                    $AgendaUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                } elseif ($field == 'ApprovedMinutesUrl') {
                    $ApprovedMinutesUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                } else {
                    $RecordingUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                }
            }
        }

        $sql = "
            INSERT INTO boardmeetingminutes
            (BoardMeetingId, BoardName, MeetingDate, AgendaUrl, ApprovedMinutesUrl, RecordingUrl, CreatedAt, CreatedBy)
            VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)
        ";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $boardId,
            $BoardName,
            $MeetingDate,
            $AgendaUrl,
            $ApprovedMinutesUrl,
            $RecordingUrl,
            $createdBy
        ]);

        $id = (int)$pdo->lastInsertId();
        audit('BoardMeetingMinutes','create',$id,[
            $boardId,
            $BoardName,
            $MeetingDate,
            $AgendaUrl,
            $ApprovedMinutesUrl,
            $RecordingUrl,
            $createdBy
        ]);
        redirect('/boardmeetingminutes');
        //header("Location: TownOfCushingME/public/list.php/boardmeetingminutes");
        //exit;
    }

    /** GET /boardmeetingminutes/edit?id=123 */
    public static function edit(): void
    {
        $id = (int)($_GET['id'] ?? 0);
        if (!$id) {
            http_response_code(400);
            echo "Missing id.";
            return;
        }
        \App\Helpers\log_info('BoardMinutes edit1:' . $id);

        $pdo = DB::pdo();
        $boards = $pdo->query("SELECT Id, CommitteeName as BoardName FROM boardsandcommittees ORDER BY CommitteeName")->fetchAll(\PDO::FETCH_ASSOC);

        $_SESSION['board_context']['pid'] = (int)$id;

        $pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
        $pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
        $pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
        $ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');
        \App\Helpers\log_info('BoardMinutes edit2:' . $pboardid);
        \App\Helpers\log_info('BoardMinutes edit3:' . $pparent);
        \App\Helpers\log_info('BoardMinutes edit4:' . $pboardmeetingid);
        \App\Helpers\log_info('BoardMinutes edit5:' . $ptitle);

        $stmt = $pdo->prepare("SELECT m.*, DATE(m.MeetingDate) as Date FROM boardmeetingminutes m WHERE m.Id = ?");
        $stmt->execute([$pboardmeetingid]);
        $resource = $stmt->fetch(\PDO::FETCH_ASSOC);
        \App\Helpers\log_info('BoardMinutes edit date:' . $resource['Date']);
        \App\Helpers\log_info('BoardMinutes edit boardname:' . $resource['BoardName']);

        if (!$resource) {
            echo "Resource not found.";
            return;
        }

        // Convert MeetingDate to yyyy-mm-dd for <input type="date">
        //$record['MeetingDate'] = substr($record['MeetingDate'], 0, 10);

        $page_title = 'Edit Board Meeting Minutes';
        require __DIR__ . '/../Views/boardmeetingminutes/form.php';
    }

    /** POST /boardmeetingminutes/update */
    public static function update(): void
    {
        $pdo = DB::pdo();

        $id = (int)($_GET['id'] ?? ($_SESSION['board_context']['pid'] ?? 0));
        $pboardid = (int)($_GET['boardid'] ?? ($_SESSION['board_context']['pboardid'] ?? 0));
        $pparent  = $_GET['parent'] ?? ($_SESSION['board_context']['pparent'] ?? '');
        $pboardmeetingid      = (int)($_GET['id'] ?? ($_SESSION['board_context']['pboardmeetingid'] ?? 0));
        $ptitle   = $_GET['ptitle'] ?? ($_SESSION['board_context']['ptitle'] ?? '');

        $Id = $id;

        $sel = $pdo->prepare("SELECT * FROM BoardMeetingMinutes WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $BoardId = $pboardid;
        $BoardMeetingId = $pboardmeetingid;
        $BoardName = $ptitle;
        $MeetingDate = trim((string)($_POST['Date'] ?? ''));
        $AgendaUrl = trim((string)($_POST['AgendaUrl'] ?? ''));
        $ApprovedMinutesUrl = trim((string)($_POST['ApprovedMinutesUrl'] ?? ''));
        $RecordingUrl = trim((string)($_POST['RecordingUrl'] ?? ''));
        \App\Helpers\log_info('BoardMinutes update:' . $Id);
        \App\Helpers\log_info('BoardMinutes update:' . $BoardId);
        \App\Helpers\log_info('BoardMinutes update:' . $BoardMeetingId);
        \App\Helpers\log_info('BoardMinutes update:' . $BoardName);
        \App\Helpers\log_info('BoardMinutes update:' . $MeetingDate);

        if (!$Id || !$BoardId || !$MeetingDate) {
            http_response_code(400);
            echo "Id, Board and Meeting Date are required.";
            return;
        }

        //$MeetingDateDT = $MeetingDate . ' 00:00:00';

        //Save file/url
        $parentTable = 'BoardMeetingMinutes';
        foreach (['AgendaUrl', 'ApprovedMinutesUrl', 'RecordingUrl'] as $field) {
            $inputName = 'attachment_' . $field;
            $upload = \App\Helpers\handleUpload($inputName, $parentTable);
            if ($upload) {
                if ($field == 'AgendaUrl') {
                    $AgendaUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                } elseif ($field == 'ApprovedMinutesUrl') {
                    $ApprovedMinutesUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                } else {
                    $RecordingUrl = $GLOBALS['CONFIG']['app']['PrependURL'] . $upload['FilePath'];
                }
            }
        }

        $sql = "
            UPDATE boardmeetingminutes
            SET MeetingDate=?, AgendaUrl=?, ApprovedMinutesUrl=?, RecordingUrl=?
            WHERE Id=?
        ";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $MeetingDate,
            $AgendaUrl,
            $ApprovedMinutesUrl,
            $RecordingUrl,
            $Id
        ]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('BoardMeetingMinutes','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/boardmeetingminutes');
        //header("Location: TownOfCushingME/public/list.php/boardmeetingminutes");
        //exit;
    }

    /** POST /boardmeetingminutes/delete */
    public static function delete(): void
    {
        $pdo = DB::pdo();

        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);

        if (!$id) {
            http_response_code(400);
            echo "Missing id.";
            return;
        }

        $sel = $pdo->prepare("SELECT * FROM BoardMeetingMinutes WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];

        $stmt = $pdo->prepare("DELETE FROM boardmeetingminutes WHERE Id = ?");
        $stmt->execute([$id]);

        audit('BoardMeetingMinutes','delete',$id,['before'=>$row]);
        redirect('/boardmeetingminutes');
        //header("Location: TownOfCushingME/public/list.php/boardmeetingminutes");
        //exit;
    }

    private static function nullIfEmpty($v)
    {
        $v = is_string($v) ? trim($v) : $v;
        return ($v === '' ? null : $v);
    }
}
