<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class BoardLinksController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT l.Id, l.BoardId, l.Title, l.LinkType, l.Url, b.CommitteeName
        FROM BoardLinks l 
        LEFT JOIN BoardsAndCommittees b ON b.Id = l.BoardId
        ORDER BY l.BoardId, l.Title";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'BoardLinks';
        include __DIR__ . '/../Views/boardlinks/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
        ob_start();
        $title = 'New BoardLinks';
        include __DIR__ . '/../Views/boardlinks/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $data = [
            'BoardId' => (int)($_POST['BoardId'] ?? 0),
            'LinkType' => trim((string)($_POST['LinkType'] ?? '')),
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Url' => trim((string)($_POST['Url'] ?? '')),
            'Remarks' => trim((string)($_POST['Remarks'] ?? ''))
        ];

        $sql = "INSERT INTO BoardLinks (BoardId, LinkType, Title, Url, Remarks, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, NOW(0), ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([(int)($_POST['BoardId'] ?? 0), trim((string)($_POST['LinkType'] ?? '')), trim((string)($_POST['Title'] ?? '')), trim((string)($_POST['Url'] ?? '')), trim((string)($_POST['Remarks'] ?? '')), $createdBy]);

        $id = (int)$pdo->lastInsertId();
        audit('BoardLinks','create',$id,$data);
        redirect('/boardlinks');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT l.*, b.CommitteeName FROM BoardLinks l LEFT JOIN BoardsAndCommittees b ON b.Id = l.BoardId WHERE l.Id=?");
        $stmt->execute([$id]);
        $model = $stmt->fetch();
        if (!$model) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/boardlinks/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardLinks WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'BoardId' => (int)($_POST['BoardId'] ?? 0),
            'LinkType' => trim((string)($_POST['LinkType'] ?? '')),
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Url' => trim((string)($_POST['Url'] ?? '')),
            'Remarks' => trim((string)($_POST['Remarks'] ?? ''))
        ];
        $sql = "UPDATE BoardLinks SET BoardId=?, LinkType=?, Title=?, Url=?, Remarks=? WHERE Id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([(int)($_POST['BoardId'] ?? 0), trim((string)($_POST['LinkType'] ?? '')), trim((string)($_POST['Title'] ?? '')), trim((string)($_POST['Url'] ?? '')), trim((string)($_POST['Remarks'] ?? '')), $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('BoardLinks','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/boardlinks');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM BoardLinks WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM BoardLinks WHERE Id=?");
        $stmt->execute([$id]);
        audit('BoardLinks','delete',$id,['before'=>$row]);
        redirect('/boardlinks');
    }
}
