<?php
namespace App\Controllers;

use App\Models\DB;
use function App\Helpers\csrf_field;
use function App\Helpers\csrf_verify;
use function App\Helpers\audit;
use function App\Helpers\redirect;

class AnnouncementsController {

    public static function index(): string {
        $pdo = DB::pdo();
        $sql = "SELECT Id, Title, StartDate, EndDate, IsActive FROM Announcements ORDER BY StartDate DESC, Title";
        $rows = $pdo->query($sql)->fetchAll();
        ob_start();
        $title = 'Announcements';
        include __DIR__ . '/../Views/announcements/list.php';
        return ob_get_clean();
    }

    public static function create(): string {
        $resource = [];
        ob_start();
        $title = 'New Announcements';
        include __DIR__ . '/../Views/announcements/form.php';
        return ob_get_clean();
    }

    public static function store(): void {
        csrf_verify();
        $pdo = DB::pdo();
        $createdBy = \App\Helpers\current_username();
        $data = [
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Body' => trim((string)($_POST['Body'] ?? '')),
            'StartDate' => ($_POST['StartDate'] !== '' ? $_POST['StartDate'] : null),
            'EndDate' => ($_POST['EndDate'] !== '' ? $_POST['EndDate'] : null),
            'IsActive' => (isset($_POST['IsActive']) ? 1 : 0),
            #'CreatedAt' => ($_POST['CreatedAt'] !== '' ? str_replace('T',' ', $_POST['CreatedAt']) : null),
            'CreatedBy' => $createdBy
        ];
        #if ($data['CreatedAt'] === null || $data['CreatedAt'] === '') {
        #    $data['CreatedAt'] = gmdate('Y-m-d H:i:s');
        #}

        $sql = "INSERT INTO Announcements (Title, Body, StartDate, EndDate, IsActive, CreatedAt, CreatedBy) VALUES (?, ?, ?, ?, ?, NOW(3), ?)";
        \App\Helpers\log_info("Announcements.store SQL: {$sql}");
        $stmt = $pdo->prepare($sql);
        $stmt->execute([trim((string)($_POST['Title'] ?? '')), trim((string)($_POST['Body'] ?? '')), ($_POST['StartDate'] !== '' ? $_POST['StartDate'] : null), ($_POST['EndDate'] !== '' ? $_POST['EndDate'] : null), (isset($_POST['IsActive']) ? 1 : 0), $createdBy]);

        $id = (int)$pdo->lastInsertId();
        audit('Announcements','create',$id,$data);
        redirect('/announcements');
    }

    public static function edit(): string {
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM Announcements WHERE Id=?");
        $stmt->execute([$id]);
        $resource = $stmt->fetch();
        if (!$resource) {
            http_response_code(404);
            return "Not found";
        }
        ob_start();
        $title = 'Edit';
        include __DIR__ . '/../Views/announcements/form.php';
        return ob_get_clean();
    }

    public static function update(): void {
        csrf_verify();
        $id = (int)($_POST['Id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM Announcements WHERE Id=?");
        $sel->execute([$id]);
        $before = $sel->fetch() ?: [];

        $data = [
            'Title' => trim((string)($_POST['Title'] ?? '')),
            'Body' => trim((string)($_POST['Body'] ?? '')),
            'StartDate' => ($_POST['StartDate'] !== '' ? $_POST['StartDate'] : null),
            'EndDate' => ($_POST['EndDate'] !== '' ? $_POST['EndDate'] : null),
            'IsActive' => (isset($_POST['IsActive']) ? 1 : 0)
            #'CreatedAt' => ($_POST['CreatedAt'] !== '' ? str_replace('T',' ', $_POST['CreatedAt']) : null),
            #'CreatedBy' => trim((string)($_POST['CreatedBy'] ?? ''))
        ];
        $sql = "UPDATE Announcements SET Title=?, Body=?, StartDate=?, EndDate=?, IsActive=? WHERE Id=?";
        \App\Helpers\log_info("Announcements.update SQL: {$sql}");
        $stmt = $pdo->prepare($sql);
        $stmt->execute([trim((string)($_POST['Title'] ?? '')), trim((string)($_POST['Body'] ?? '')), ($_POST['StartDate'] !== '' ? $_POST['StartDate'] : null), ($_POST['EndDate'] !== '' ? $_POST['EndDate'] : null), (isset($_POST['IsActive']) ? 1 : 0), $id]);

        $sel->execute([$id]);
        $after = $sel->fetch() ?: [];
        audit('Announcements','update',$id,['before'=>$before,'after'=>$after]);
        redirect('/announcements');
    }

    public static function delete(): void {
        csrf_verify();
        $id = (int)($_POST['id'] ?? 0);
        $pdo = DB::pdo();
        $sel = $pdo->prepare("SELECT * FROM Announcements WHERE Id=?");
        $sel->execute([$id]);
        $row = $sel->fetch() ?: [];
        $stmt = $pdo->prepare("DELETE FROM Announcements WHERE Id=?");
        $stmt->execute([$id]);
        audit('Announcements','delete',$id,['before'=>$row]);
        redirect('/announcements');
    }
}
